/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import workbench.db.DbObject;
import workbench.db.ProcedureDefinition;
import workbench.db.WbConnection;
import workbench.db.oracle.OracleObjectCompiler;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.dbobjects.DbObjectList;
import workbench.gui.dbobjects.ObjectCompilerUI;
import workbench.interfaces.WbSelectionListener;
import workbench.interfaces.WbSelectionModel;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.util.CollectionUtil;

public class CompileDbObjectAction
extends WbAction
implements WbSelectionListener {
    private JMenuItem menuItem;
    private DbObjectList source;
    private WbSelectionModel selection;

    public CompileDbObjectAction(DbObjectList dbObjectList, WbSelectionModel wbSelectionModel) {
        this.initMenuDefinition("MnuTxtRecompile");
        this.source = dbObjectList;
        this.selection = wbSelectionModel;
        this.setVisible(false);
        this.checkState();
    }

    public void setVisible(boolean bl) {
        if (this.menuItem == null) {
            this.menuItem = this.getMenuItem();
        }
        this.menuItem.setVisible(bl);
    }

    public void setConnection(WbConnection wbConnection) {
        if (wbConnection != null && wbConnection.getMetadata().isOracle()) {
            this.setVisible(true);
            this.selection.addSelectionListener(this);
            this.checkState();
        } else {
            this.selection.removeSelectionListener(this);
            this.setVisible(false);
            this.setEnabled(false);
        }
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        this.compileObjects();
    }

    private void compileObjects() {
        if (!WbSwingUtilities.isConnectionIdle(this.source.getComponent(), this.source.getConnection())) {
            return;
        }
        List<DbObject> list = this.getSelectedObjects();
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        try {
            ObjectCompilerUI objectCompilerUI = new ObjectCompilerUI(list, this.source.getConnection());
            objectCompilerUI.show(SwingUtilities.getWindowAncestor(this.source.getComponent()));
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Error initializing ObjectCompilerUI", sQLException);
        }
    }

    private List<DbObject> getSelectedObjects() {
        List<DbObject> list = this.source.getSelectedObjects();
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        Set<String> set = CollectionUtil.caseInsensitiveSet();
        ArrayList<DbObject> arrayList = new ArrayList<DbObject>();
        for (DbObject dbObject : list) {
            boolean bl;
            ProcedureDefinition procedureDefinition;
            if (!OracleObjectCompiler.canCompile(dbObject) || dbObject instanceof ProcedureDefinition && (procedureDefinition = (ProcedureDefinition)dbObject).isPackageProcedure() && !(bl = set.add(procedureDefinition.getPackageName()))) continue;
            arrayList.add(dbObject);
        }
        return arrayList;
    }

    private void checkState() {
        List<DbObject> list = this.getSelectedObjects();
        this.setEnabled(CollectionUtil.isNonEmpty(list));
    }

    @Override
    public void selectionChanged(WbSelectionModel wbSelectionModel) {
        EventQueue.invokeLater(this::checkState);
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

