/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.event.ActionEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import workbench.db.DeleteScriptGenerator;
import workbench.db.WbConnection;
import workbench.gui.actions.WbAction;
import workbench.gui.components.WbTable;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class CreateDeleteScriptAction
extends WbAction
implements ListSelectionListener {
    private WbTable client;

    public CreateDeleteScriptAction(WbTable wbTable) {
        this.initMenuDefinition("MnuTxtCreateDeleteScript", null);
        this.setMenuItemName("MnuTxtData");
        this.setClient(wbTable);
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        WbConnection wbConnection = this.client.getDataStore().getOriginalConnection();
        if (wbConnection.isBusy()) {
            return;
        }
        try {
            boolean bl = this.client.checkPkColumns(true);
            if (!bl) {
                return;
            }
            DeleteScriptGenerator deleteScriptGenerator = new DeleteScriptGenerator(wbConnection);
            deleteScriptGenerator.setEndTransaction(true);
            deleteScriptGenerator.setSource(this.client);
            deleteScriptGenerator.startGenerate();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error initializing DeleteScriptGenerator", exception);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        this.checkSelection();
    }

    private void checkSelection() {
        if (this.client == null) {
            return;
        }
        int n = this.client.getSelectedRowCount();
        this.setEnabled(n > 0);
    }

    public void setClient(WbTable wbTable) {
        if (this.client != null) {
            this.client.getSelectionModel().removeListSelectionListener(this);
        }
        this.client = wbTable;
        if (this.client != null) {
            this.client.getSelectionModel().addListSelectionListener(this);
            this.checkSelection();
        }
        this.setEnabled(this.client != null);
        this.checkSelection();
    }
}

