/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.StringReader;
import javax.swing.KeyStroke;
import workbench.gui.actions.WbAction;
import workbench.interfaces.TextContainer;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.FileUtil;
import workbench.util.QuoteEscapeType;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class CreateSnippetAction
extends WbAction {
    private TextContainer client;

    public CreateSnippetAction(TextContainer textContainer) {
        this.client = textContainer;
        this.initMenuDefinition("MnuTxtCreateSnippet", KeyStroke.getKeyStroke(79, 8));
        this.setMenuItemName("MnuTxtSQL");
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        String string = this.client.getSelectedText();
        if (string == null) {
            string = this.client.getText();
        }
        boolean bl = true;
        if (CreateSnippetAction.invokedByMouse(actionEvent) && CreateSnippetAction.isCtrlPressed(actionEvent)) {
            bl = false;
        }
        String string2 = CreateSnippetAction.makeJavaString(string, bl);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection stringSelection = new StringSelection(string2);
        clipboard.setContents(stringSelection, stringSelection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String makeJavaString(String string, boolean bl) {
        if (string == null) {
            return "";
        }
        String string2 = Settings.getInstance().getProperty("workbench.clipcreate.codeprefix", "String sql = ");
        String string3 = Settings.getInstance().getProperty("workbench.clipcreate.concat", "+");
        String string4 = StringUtil.trimQuotes(Settings.getInstance().getProperty("workbench.clipcreate.codeend", ";"));
        String string5 = StringUtil.trimQuotes(Settings.getInstance().getProperty("workbench.clipcreate.quotechar", "\""));
        QuoteEscapeType quoteEscapeType = Settings.getInstance().getEnumProperty("workbench.clipcreate.escape", QuoteEscapeType.escape);
        int n = Settings.getInstance().getIntProperty("workbench.clipcreate.indent", -1);
        boolean bl2 = Settings.getInstance().getBoolProperty("workbench.clipcreate.includenewline", true);
        boolean bl3 = Settings.getInstance().getBoolProperty("workbench.clipcreate.startnewline", false);
        StringBuilder stringBuilder = new StringBuilder(string.length() + string2.length() + 10);
        stringBuilder.append(string2);
        boolean bl4 = true;
        if (bl3) {
            stringBuilder.append('\n');
            bl4 = false;
        } else if (string2.endsWith("=")) {
            stringBuilder.append(" ");
        }
        if (n <= 0) {
            n = stringBuilder.length();
        }
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        try {
            String string6 = bufferedReader.readLine();
            while (string6 != null) {
                if (quoteEscapeType == QuoteEscapeType.duplicate) {
                    string6 = StringUtil.replace(string6, string5, string5 + string5);
                } else if (quoteEscapeType == QuoteEscapeType.escape) {
                    string6 = StringUtil.replace(string6, "\"", "\\" + string5);
                }
                if (bl4) {
                    bl4 = false;
                } else {
                    stringBuilder.append((CharSequence)stringBuilder2);
                }
                stringBuilder.append(string5);
                if (bl) {
                    string6 = SqlUtil.trimSemicolon(string6);
                }
                stringBuilder.append(string6);
                string6 = bufferedReader.readLine();
                if (string6 != null) {
                    if (bl2) {
                        stringBuilder.append(" \\n");
                        stringBuilder.append(string5);
                    } else {
                        stringBuilder.append(' ');
                        stringBuilder.append(string5);
                    }
                    stringBuilder.append(' ').append(string3).append('\n');
                    continue;
                }
                stringBuilder.append(string5);
            }
            stringBuilder.append(string4);
        }
        catch (Exception exception) {
            stringBuilder.append("(Error when creating Java code, see logfile for details)");
            LogMgr.logError(new CallerInfo(){}, "Error creating Java String", exception);
        }
        finally {
            FileUtil.closeQuietely(bufferedReader);
        }
        return stringBuilder.toString();
    }
}

