/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.sql.SqlPanel;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.util.ExceptionUtil;
import workbench.util.StringUtil;

public class ImportClipboardAction
extends WbAction {
    private SqlPanel client;

    public ImportClipboardAction(SqlPanel sqlPanel) {
        this.initMenuDefinition("MnuTxtImportClip");
        this.setMenuItemName("MnuTxtData");
        this.client = sqlPanel;
        this.setEnabled(false);
    }

    @Override
    public boolean hasCtrlModifier() {
        return true;
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        String string = this.getClipboardContents();
        if (StringUtil.isBlank(string)) {
            return;
        }
        boolean bl = false;
        if (ImportClipboardAction.invokedByMouse(actionEvent)) {
            bl = ImportClipboardAction.isCtrlPressed(actionEvent);
        }
        this.client.importString(string, bl);
    }

    private String getClipboardContents() {
        if (this.client == null) {
            return null;
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(this.client);
        DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
        StringBuilder stringBuilder = new StringBuilder();
        if (dataFlavorArray != null) {
            for (int i = 0; i < dataFlavorArray.length; ++i) {
                stringBuilder.append(dataFlavorArray[i].getHumanPresentableName());
                if (i <= 0) continue;
                stringBuilder.append(", ");
            }
        }
        LogMgr.logDebug(new CallerInfo(){}, "Supported formats of the clipboard: " + stringBuilder);
        if (!transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            LogMgr.logError(new CallerInfo(){}, "The clipboard does not contain a format compatible with a string. Clipboard format is: " + stringBuilder, null);
            WbSwingUtilities.showErrorMessageKey(this.client, "MsgClipInvalid");
            return null;
        }
        try {
            return (String)transferable.getTransferData(DataFlavor.stringFlavor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            LogMgr.logError(new CallerInfo(){}, "The current clipboard content cannot be used as a String", unsupportedFlavorException);
            WbSwingUtilities.showErrorMessageKey(this.client, "MsgClipInvalid");
        }
        catch (IOException iOException) {
            LogMgr.logError(new CallerInfo(){}, "The current clipboard content can no longer be accessed", iOException);
            WbSwingUtilities.showErrorMessage(this.client, "<html>" + ResourceMgr.getString("MsgClipInvalid") + "<br>(" + ExceptionUtil.getDisplay(iOException) + ")</html>");
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error accessing clipboard", throwable);
        }
        return null;
    }
}

