/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.File;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.interfaces.TextFileContainer;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class OpenFileDirAction
extends WbAction {
    private TextFileContainer editor;

    public OpenFileDirAction(TextFileContainer textFileContainer) {
        this.editor = textFileContainer;
        this.initMenuDefinition("MnuTxtOpenFileDir");
        boolean bl = this.editor.getCurrentFile() != null;
        boolean bl2 = false;
        if (bl) {
            boolean bl3 = bl2 = Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.OPEN);
            if (!bl2) {
                LogMgr.logWarning(new CallerInfo(){}, "Desktop or Desktop.open() not supported!");
            }
        }
        this.setEnabled(bl && bl2);
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        if (this.editor == null) {
            return;
        }
        File file = this.editor.getCurrentFile();
        if (file == null) {
            return;
        }
        File file2 = file.getParentFile();
        if (file2 != null) {
            try {
                Desktop.getDesktop().open(file2);
            }
            catch (Exception exception) {
                WbSwingUtilities.showErrorMessage(exception.getLocalizedMessage());
            }
        }
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

