/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.SwingUtilities;
import workbench.db.DbObject;
import workbench.db.WbConnection;
import workbench.db.report.SchemaReporter;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.dbobjects.DbObjectList;
import workbench.gui.dbobjects.ProgressDialog;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.util.ExceptionUtil;
import workbench.util.FileDialogUtil;
import workbench.util.WbThread;

public class SchemaReportAction
extends WbAction {
    private DbObjectList client;

    public SchemaReportAction(DbObjectList dbObjectList) {
        this.initMenuDefinition("MnuTxtSchemaReport");
        this.client = dbObjectList;
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        this.saveReport();
    }

    protected void saveReport() {
        if (this.client == null) {
            return;
        }
        final WbConnection wbConnection = this.client.getConnection();
        final Component component = this.client.getComponent();
        if (!WbSwingUtilities.isConnectionIdle(component, wbConnection)) {
            return;
        }
        List<DbObject> list = this.client.getSelectedObjects();
        if (list == null) {
            return;
        }
        FileDialogUtil fileDialogUtil = new FileDialogUtil();
        String string = fileDialogUtil.getXmlReportFilename(this.client.getComponent());
        if (string == null) {
            return;
        }
        final SchemaReporter schemaReporter = new SchemaReporter(this.client.getConnection());
        schemaReporter.setObjectList(list);
        schemaReporter.setOutputFilename(string);
        schemaReporter.setIncludePartitions(true);
        Frame frame = (Frame)SwingUtilities.getWindowAncestor(component);
        final ProgressDialog progressDialog = new ProgressDialog(ResourceMgr.getString("MsgReportWindowTitle"), frame, schemaReporter);
        progressDialog.getInfoPanel().setObject(string);
        progressDialog.getInfoPanel().setMonitorType(7);
        schemaReporter.setProgressMonitor(progressDialog.getInfoPanel());
        progressDialog.showProgressWindow();
        WbThread wbThread = new WbThread("Schema Report"){

            @Override
            public void run() {
                try {
                    wbConnection.setBusy(true);
                    schemaReporter.writeXml();
                }
                catch (Throwable throwable) {
                    LogMgr.logError(new CallerInfo(){}, "Error writing schema report", throwable);
                    String string = ExceptionUtil.getDisplay(throwable);
                    EventQueue.invokeLater(() -> WbSwingUtilities.showErrorMessage(component, string));
                }
                finally {
                    wbConnection.setBusy(false);
                    progressDialog.finished();
                }
            }
        };
        wbThread.start();
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

