/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.components.WbTable;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;

public class ScrollToColumnAction
extends WbAction {
    private WbTable client;

    public ScrollToColumnAction(WbTable wbTable) {
        this.client = wbTable;
        this.initMenuDefinition("MnuTxtFindColumn");
        this.setIcon(null);
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        String string = Settings.getInstance().getProperty("workbench.gui.findcolumn.lastvalue", null);
        String string2 = WbSwingUtilities.getUserInput(this.client, ResourceMgr.getPlainString("MnuTxtFindColumn"), string);
        if (string2 != null) {
            Settings.getInstance().setProperty("workbench.gui.findcolumn.lastvalue", string2);
            this.scrollToColumn(string2.toLowerCase());
        }
    }

    protected void scrollToColumn(String string) {
        if (StringUtil.isBlank(string)) {
            return;
        }
        for (int i = 0; i < this.client.getModel().getColumnCount(); ++i) {
            String string2 = this.client.getModel().getColumnName(i);
            if (string2.toLowerCase().indexOf(string) <= -1) continue;
            int n = this.client.getSelectedRow();
            if (n < 0) {
                n = this.client.getFirstVisibleRow();
            }
            Rectangle rectangle = this.client.getCellRect(n, i, true);
            EventQueue.invokeLater(() -> {
                this.client.scrollRectToVisible(rectangle);
                this.client.getTableHeader().repaint();
                this.client.repaint();
            });
        }
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

