/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.actions;

import java.awt.Container;
import java.awt.event.ActionEvent;
import workbench.gui.actions.WbAction;
import workbench.gui.components.WbTable;
import workbench.gui.sql.SqlPanel;
import workbench.resource.GuiSettings;
import workbench.storage.DataStore;
import workbench.storage.DatastoreTransposer;

public class TransposeRowAction
extends WbAction {
    private WbTable client;

    public TransposeRowAction(WbTable wbTable) {
        this.client = wbTable;
        this.initMenuDefinition("MnuTxtTransposeRow");
        this.setEnabled(this.client != null);
    }

    @Override
    public void executeAction(ActionEvent actionEvent) {
        DataStore dataStore;
        DatastoreTransposer datastoreTransposer = new DatastoreTransposer(this.client.getDataStore());
        datastoreTransposer.setUseTableNameForResult(GuiSettings.getUseTablenameAsResultName());
        int[] nArray = null;
        if (this.client.getSelectedRowCount() > 0) {
            nArray = this.client.getSelectedRows();
        }
        if ((dataStore = datastoreTransposer.transposeRows(nArray)).getResultName() != null) {
            dataStore.setResultName("<[ " + dataStore.getResultName() + " ]>");
        }
        this.showDatastore(dataStore);
    }

    private void showDatastore(DataStore dataStore) {
        SqlPanel sqlPanel = this.findPanel();
        if (sqlPanel != null) {
            sqlPanel.showData(dataStore);
        }
    }

    private SqlPanel findPanel() {
        if (this.client == null) {
            return null;
        }
        for (Container container = this.client.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof SqlPanel)) continue;
            return (SqlPanel)container;
        }
        return null;
    }

    @Override
    public boolean useInToolbar() {
        return false;
    }
}

