/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.completion;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import workbench.db.ColumnIdentifier;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.objectcache.Namespace;
import workbench.gui.completion.BaseAnalyzer;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.sql.formatter.WbSqlFormatter;
import workbench.sql.lexer.LexerState;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.util.Alias;
import workbench.util.CollectionUtil;
import workbench.util.SqlParsingUtil;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;
import workbench.util.TableAlias;

public class SelectAnalyzer
extends BaseAnalyzer {
    private final int NO_JOIN_ON = 0;
    private final int JOIN_ON_TABLE_LIST = 1;
    private final int JOIN_FROM_TABLE_LIST = 2;
    private final int JOIN_ON_COLUMN_LIST = 3;

    public SelectAnalyzer(WbConnection wbConnection, String string, int n) {
        super(wbConnection, string, n);
    }

    @Override
    protected void checkContext() {
        boolean bl;
        boolean bl2;
        boolean bl3;
        this.context = -1;
        String string = this.getCurrentWord();
        this.appendDot = false;
        this.setColumnPrefix(null);
        SqlParsingUtil sqlParsingUtil = SqlParsingUtil.getInstance(this.dbConnection);
        int n = sqlParsingUtil.getFromPosition(this.sql);
        int n2 = -1;
        int n3 = -1;
        if (n > 0) {
            n2 = sqlParsingUtil.getWherePosition(this.sql);
            n3 = sqlParsingUtil.getJoinPosition(this.sql);
        }
        int n4 = sqlParsingUtil.getKeywordPosition("GROUP BY", (CharSequence)this.sql);
        int n5 = sqlParsingUtil.getKeywordPosition("HAVING", (CharSequence)this.sql);
        int n6 = sqlParsingUtil.getKeywordPosition("ORDER BY", (CharSequence)this.sql);
        int n7 = -1;
        int n8 = sqlParsingUtil.getKeywordPosition("CONNECT BY", (CharSequence)this.sql);
        int n9 = sqlParsingUtil.getKeywordPosition("START WITH", (CharSequence)this.sql);
        n7 = n8 > -1 && n9 > -1 ? Math.min(n8, n9) : Math.max(n8, n9);
        List<Alias> list = SqlUtil.getTables(this.sql, true, this.dbConnection);
        boolean bl4 = n2 > 0 && this.cursorPos > n2;
        boolean bl5 = n4 > 0 && this.cursorPos > n4;
        boolean bl6 = bl3 = n6 > 0 && this.cursorPos > n6;
        if (n5 > -1 && bl5) {
            boolean bl7 = bl5 = this.cursorPos < n5;
        }
        if (n6 > -1 && bl5) {
            bl5 = this.cursorPos < n6;
        }
        boolean bl8 = bl2 = n5 > 0 && this.cursorPos > n5;
        if (n6 > -1 && bl2) {
            bl2 = this.cursorPos < n6;
        }
        boolean bl9 = this.cursorPos < n;
        boolean bl10 = this.between(this.cursorPos, n, n3) || this.between(this.cursorPos, n, n2);
        boolean bl11 = bl = this.between(this.cursorPos, n2, n6) || this.between(this.cursorPos, n2, n4) || this.between(this.cursorPos, n2, n5) || this.between(this.cursorPos, n7, n4);
        if (bl10 && (bl || bl5 || bl3)) {
            bl10 = false;
        }
        int n10 = 0;
        if (n3 > 0 && bl10 && (n10 = this.inJoinONPart(list)) == 3) {
            bl10 = false;
        }
        if (bl10 && n10 == 2) {
            this.context = 3;
            this.appendDot = true;
            this.elements = new ArrayList();
            for (Alias alias : list) {
                if (alias.getStartPositionInQuery() >= 0 && alias.getStartPositionInQuery() > this.cursorPos) continue;
                this.elements.add(TableAlias.createFrom(alias));
            }
            return;
        }
        if (bl10) {
            String string2 = this.getQualifierLeftOfCursor();
            if (string2 != null) {
                this.setOverwriteCurrentWord(true);
            }
            if (n < 0 && string2 != null) {
                this.context = 4;
                this.tableForColumnList = new TableIdentifier(string2, this.dbConnection);
            } else {
                this.context = 1;
            }
            this.namespaceForTableList = this.getNamespaceFromCurrentWord();
            if (this.isCurrentNameSpaceCatalog()) {
                this.namespaceForTableList = new Namespace(null, this.namespaceForTableList.toString());
                this.context = 11;
            }
        } else {
            List<String> list2;
            this.context = 2;
            int n11 = list.size();
            this.tableForColumnList = null;
            if (bl5) {
                this.elements = this.getColumnsForGroupBy();
                this.addAllMarker = true;
                this.title = ResourceMgr.getString("TxtTitleColumns");
                return;
            }
            if (bl2) {
                this.elements = this.getColumnsForHaving();
                this.addAllMarker = false;
                this.title = ResourceMgr.getString("TxtTitleGroupFuncs");
                return;
            }
            this.addAllMarker = !bl4;
            TableAlias tableAlias = null;
            String string3 = null;
            if (string != null) {
                int n12 = string.indexOf(this.catalogSeparator);
                if (n12 == -1) {
                    n12 = string.indexOf(this.schemaSeparator);
                }
                if (n12 > -1) {
                    string3 = string.substring(0, n12);
                }
            }
            if (string3 != null) {
                List<TableAlias> list3;
                tableAlias = this.findAlias(string3, list, this.catalogSeparator, this.schemaSeparator);
                if (tableAlias != null) {
                    this.tableForColumnList = tableAlias.getTable();
                } else if (this.parentAnalyzer != null && (list3 = this.parentAnalyzer.getTables()) != null) {
                    for (TableAlias tableAlias2 : list3) {
                        if (!tableAlias2.isTableOrAlias(string3, this.catalogSeparator, this.schemaSeparator)) continue;
                        this.tableForColumnList = tableAlias2.getTable();
                        tableAlias = tableAlias2;
                    }
                }
            } else {
                if ((bl || bl9) && n11 > 1) {
                    this.elements = this.getColumnsForAllTables(list);
                    return;
                }
                if (n11 == 1) {
                    TableAlias tableAlias3 = new TableAlias(list.get(0).getObjectName(), null, this.catalogSeparator, this.schemaSeparator);
                    this.tableForColumnList = tableAlias3.getTable();
                }
            }
            if (bl3 && tableAlias == null && !this.isSelectStar(list2 = this.getColumnsForOrderBy())) {
                this.elements = list2;
                this.addAllMarker = true;
                this.title = ResourceMgr.getString("TxtTitleColumns");
                return;
            }
            if (this.tableForColumnList == null) {
                this.context = 3;
                this.addAllMarker = false;
                this.elements = new ArrayList();
                for (Alias alias : list) {
                    TableAlias tableAlias2;
                    tableAlias2 = new TableAlias(alias.getObjectName(), alias.getAlias(), this.catalogSeparator, this.schemaSeparator);
                    this.elements.add(tableAlias2);
                    this.appendDot = true;
                }
            } else if (tableAlias != null) {
                this.setColumnPrefix(tableAlias.getNameToUse());
            }
        }
        if (bl) {
            this.fkMarker = this.checkFkLookup();
            if (this.fkMarker != null && this.elements != null) {
                this.elements.add(this.fkMarker);
            }
        }
    }

    private boolean isSelectStar(List<String> list) {
        if (list.size() != 1) {
            return false;
        }
        return list.get(0).equals("*");
    }

    private TableAlias findAlias(String string, List<Alias> list, char c, char c2) {
        for (Alias alias : list) {
            TableAlias tableAlias = new TableAlias(alias.getObjectName(), alias.getAlias(), c, c2);
            tableAlias.setAlias(alias.getAlias());
            if (!tableAlias.isTableOrAlias(string, c, c2)) continue;
            return tableAlias;
        }
        return null;
    }

    private int inJoinONPart(List<Alias> list) {
        int n = 0;
        Set<String> set = SqlUtil.getJoinKeyWords();
        try {
            boolean bl = false;
            SQLLexer sQLLexer = SQLLexerFactory.createLexer(this.dbConnection, this.sql);
            SQLToken sQLToken = sQLLexer.getNextToken(false, false);
            SQLToken sQLToken2 = null;
            LexerState lexerState = new LexerState();
            while (sQLToken != null) {
                lexerState.visit(sQLToken);
                String string = sQLToken.getContents();
                if (bl) {
                    String string2;
                    if ("ON".equals(string)) {
                        if (this.cursorPos >= sQLToken.getCharEnd()) {
                            string2 = this.getQualifierLeftOfCursor();
                            n = string2 == null ? 2 : 3;
                        }
                    } else if ("USING".equals(string)) {
                        if (this.cursorPos >= sQLToken.getCharEnd()) {
                            n = 3;
                        }
                    } else {
                        if (n == 3 && this.cursorPos <= sQLToken.getCharBegin()) {
                            string2 = this.getCurrentWord();
                            if (string2 != null && string2.endsWith(".") && string2.length() > 1) {
                                char c;
                                TableAlias tableAlias = this.findAlias(string2 = string2.substring(0, string2.length() - 1), list, this.catalogSeparator, c = SqlUtil.getSchemaSeparator(this.dbConnection));
                                if (tableAlias == null) {
                                    n = 1;
                                } else {
                                    this.tableForColumnList = tableAlias.getTable();
                                }
                            }
                            break;
                        }
                        if (set.contains(string)) {
                            if (sQLToken2 != null && this.cursorPos > sQLToken2.getCharEnd() && this.cursorPos <= sQLToken.getCharBegin() && sQLToken2.getContents().equals("ON")) {
                                return 2;
                            }
                            n = sQLToken2 != null && this.cursorPos > sQLToken2.getCharEnd() && this.cursorPos <= sQLToken.getCharBegin() && SqlUtil.getJoinKeyWords().contains(sQLToken2.getContents()) ? 1 : (this.cursorPos > sQLToken.getCharEnd() ? 1 : 0);
                        } else if (!lexerState.inParentheses() && WbSqlFormatter.FROM_TERMINAL.contains(string)) {
                            return n;
                        }
                    }
                } else {
                    if (!lexerState.inParentheses() && WbSqlFormatter.FROM_TERMINAL.contains(string)) break;
                    if (string.equals("FROM")) {
                        if (this.cursorPos < sQLToken.getCharBegin()) {
                            return 0;
                        }
                        bl = true;
                        n = 1;
                    }
                }
                sQLToken2 = sQLToken;
                sQLToken = sQLLexer.getNextToken(false, false);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error parsing SQL Statement!", exception);
        }
        return n;
    }

    private List<ColumnIdentifier> getColumnsForAllTables(List<Alias> list) {
        if (this.dbConnection == null) {
            return null;
        }
        if (CollectionUtil.isEmpty(list)) {
            return null;
        }
        ArrayList<ColumnIdentifier> arrayList = new ArrayList<ColumnIdentifier>();
        for (Alias alias : list) {
            TableAlias tableAlias = new TableAlias(alias.getObjectName(), null, this.catalogSeparator, this.schemaSeparator);
            TableIdentifier tableIdentifier = tableAlias.getTable();
            List<ColumnIdentifier> list2 = this.retrieveColumnsForTable(tableIdentifier);
            if (!CollectionUtil.isNonEmpty(list2)) continue;
            for (ColumnIdentifier columnIdentifier : list2) {
                if (list.size() > 1) {
                    final String string = alias.getNameToUse();
                    ColumnIdentifier columnIdentifier2 = new ColumnIdentifier(columnIdentifier.getColumnName(), columnIdentifier.getDataType()){

                        @Override
                        public String getColumnName() {
                            return string + "." + super.getColumnName();
                        }

                        @Override
                        public String toString() {
                            return this.getColumnName();
                        }
                    };
                    columnIdentifier2.setDbmsType(columnIdentifier.getDbmsType());
                    columnIdentifier2.setColumnTypeName(columnIdentifier.getColumnTypeName());
                    columnIdentifier2.setIsNullable(columnIdentifier.isNullable());
                    columnIdentifier2.setIsAutoincrement(columnIdentifier.isAutoincrement());
                    columnIdentifier2.setIsIdentity(columnIdentifier.isIdentityColumn());
                    arrayList.add(columnIdentifier2);
                    continue;
                }
                arrayList.add(columnIdentifier);
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    private List<String> getColumnsForOrderBy() {
        return SqlUtil.getSelectColumns(this.sql, false, this.dbConnection);
    }

    private List getColumnsForHaving() {
        List<String> list = SqlUtil.getSelectColumns(this.sql, false, this.dbConnection);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (string.indexOf(40) <= -1 || string.indexOf(41) <= -1) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private List getColumnsForGroupBy() {
        List<String> list = SqlUtil.getSelectColumns(this.sql, false, this.dbConnection);
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = new String[]{"sum", "count", "avg", "min", "max"};
        StringBuilder stringBuilder = new StringBuilder(50);
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append('|');
            }
            stringBuilder.append("\\s*");
            stringBuilder.append(stringArray[i]);
            stringBuilder.append("\\s*\\(");
        }
        Pattern pattern = Pattern.compile(stringBuilder.toString(), 2);
        for (String string : list) {
            if (StringUtil.findPattern(pattern, string, 0) != -1) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    @Override
    public List<TableAlias> getTables() {
        List<Alias> list = SqlUtil.getTables(this.sql, true, this.dbConnection);
        ArrayList<TableAlias> arrayList = new ArrayList<TableAlias>(list.size());
        for (Alias alias : list) {
            TableAlias tableAlias = TableAlias.createFrom(alias);
            arrayList.add(tableAlias);
        }
        return arrayList;
    }
}

