/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.completion;

import java.util.ArrayList;
import java.util.List;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.objectcache.Namespace;
import workbench.gui.completion.BaseAnalyzer;
import workbench.sql.formatter.WbSqlFormatter;
import workbench.sql.lexer.SQLLexer;
import workbench.sql.lexer.SQLLexerFactory;
import workbench.sql.lexer.SQLToken;
import workbench.util.SqlUtil;
import workbench.util.TableAlias;

public class UpdateAnalyzer
extends BaseAnalyzer {
    public UpdateAnalyzer(WbConnection wbConnection, String string, int n) {
        super(wbConnection, string, n);
    }

    @Override
    protected void checkContext() {
        this.checkOverwrite();
        int n = -1;
        boolean bl = false;
        String string = null;
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(this.dbConnection, this.sql);
        SQLToken sQLToken = sQLLexer.getNextToken(false, false);
        while (sQLToken != null) {
            if (bl) {
                if (this.catalogSeparator != '.') {
                    StringBuilder stringBuilder = new StringBuilder(sQLToken.getContents());
                    sQLToken = SqlUtil.appendCurrentTablename(sQLLexer, stringBuilder, this.catalogSeparator);
                    string = stringBuilder.toString();
                } else {
                    string = sQLToken.getContents();
                }
                bl = false;
                continue;
            }
            if (sQLToken.getContents().equals("UPDATE")) {
                bl = true;
                if (this.cursorPos > sQLToken.getCharEnd()) {
                    n = 2;
                }
            } else if (sQLToken.getContents().equals("SET")) {
                if (this.cursorPos > sQLToken.getCharEnd()) {
                    n = 1;
                }
            } else if (WbSqlFormatter.SET_TERMINAL.contains(sQLToken.getContents()) && this.cursorPos > sQLToken.getCharEnd()) {
                n = 3;
            }
            sQLToken = sQLLexer.getNextToken(false, false);
        }
        if (n == 2) {
            this.context = 1;
            this.namespaceForTableList = this.getNamespaceFromCurrentWord();
            if (this.isCurrentNameSpaceCatalog()) {
                this.namespaceForTableList = new Namespace(null, this.namespaceForTableList.toString());
                this.context = 11;
            }
        } else if (string != null) {
            this.context = 2;
            this.tableForColumnList = new TableIdentifier(string, this.dbConnection);
            this.fkMarker = this.checkFkLookup();
        }
    }

    String getCurrentColumn() {
        List<ColumnInfo> list = this.getColumns();
        for (ColumnInfo columnInfo : list) {
            if (this.cursorPos < columnInfo.valueStartPos || this.cursorPos > columnInfo.valueEndPos) continue;
            return columnInfo.name;
        }
        return null;
    }

    List<ColumnInfo> getColumns() {
        String string;
        ArrayList<ColumnInfo> arrayList = new ArrayList<ColumnInfo>();
        SQLLexer sQLLexer = SQLLexerFactory.createLexer(this.dbConnection, this.sql);
        SQLToken sQLToken = sQLLexer.getNextToken(false, false);
        SQLToken sQLToken2 = null;
        boolean bl = false;
        boolean bl2 = false;
        while (sQLToken != null) {
            string = sQLToken.getContents();
            if (bl) {
                ColumnInfo columnInfo;
                if (WbSqlFormatter.SET_TERMINAL.contains(string)) {
                    bl2 = true;
                    ColumnInfo columnInfo2 = columnInfo = arrayList.size() > 0 ? (ColumnInfo)arrayList.get(arrayList.size() - 1) : null;
                    if (columnInfo != null && columnInfo.valueEndPos == 0) {
                        columnInfo.valueEndPos = sQLToken.getCharBegin();
                    }
                } else if (bl2 && !sQLToken.isReservedWord()) {
                    columnInfo = new ColumnInfo();
                    columnInfo.name = string;
                    columnInfo.valueStartPos = 0;
                    columnInfo.valueEndPos = 0;
                    arrayList.add(columnInfo);
                    bl2 = false;
                } else if (string.equals(",")) {
                    bl2 = true;
                    ColumnInfo columnInfo3 = columnInfo = arrayList.size() > 0 ? (ColumnInfo)arrayList.get(arrayList.size() - 1) : null;
                    if (columnInfo != null) {
                        columnInfo.valueEndPos = sQLToken.getCharBegin();
                    }
                } else if (sQLToken.isLiteral() && sQLToken2 != null && sQLToken2.getText().equals("=")) {
                    ColumnInfo columnInfo4 = columnInfo = arrayList.size() > 0 ? (ColumnInfo)arrayList.get(arrayList.size() - 1) : null;
                    if (columnInfo != null) {
                        columnInfo.valueEndPos = sQLToken.getCharEnd();
                    }
                } else if (sQLToken.isOperator()) {
                    bl2 = false;
                    ColumnInfo columnInfo5 = columnInfo = arrayList.size() > 0 ? (ColumnInfo)arrayList.get(arrayList.size() - 1) : null;
                    if (columnInfo != null) {
                        columnInfo.valueStartPos = sQLToken.getCharEnd();
                    }
                }
            } else if (string.equalsIgnoreCase("SET")) {
                bl = true;
                bl2 = true;
            }
            sQLToken2 = sQLToken;
            sQLToken = sQLLexer.getNextToken(false, false);
        }
        if (bl && sQLToken2 != null && sQLToken2.isOperator()) {
            String string2 = string = arrayList.size() > 0 ? (ColumnInfo)arrayList.get(arrayList.size() - 1) : null;
            if (string != null && ((ColumnInfo)((Object)string)).valueEndPos == 0) {
                ((ColumnInfo)((Object)string)).valueEndPos = this.sql.length();
            }
        }
        return arrayList;
    }

    @Override
    public List<TableAlias> getTables() {
        char c = SqlUtil.getSchemaSeparator(this.dbConnection);
        String string = SqlUtil.getUpdateTable(this.sql, this.catalogSeparator, this.dbConnection);
        TableAlias tableAlias = new TableAlias(string, this.catalogSeparator, c);
        ArrayList<TableAlias> arrayList = new ArrayList<TableAlias>(1);
        arrayList.add(tableAlias);
        return arrayList;
    }

    class ColumnInfo {
        String name;
        int valueStartPos;
        int valueEndPos;

        ColumnInfo() {
        }

        public String toString() {
            return "Column: " + this.name + ", value from: " + this.valueStartPos + " to: " + this.valueEndPos;
        }
    }
}

