/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalTabbedPaneUI;
import workbench.gui.components.TabHighlightSupport;
import workbench.gui.components.TabHighlighter;
import workbench.gui.components.TabbedPaneUIFactory;

public class BorderLessMetalTabbedPaneUI
extends MetalTabbedPaneUI
implements TabHighlightSupport {
    private Color selColor;
    private TabHighlighter highlighter;

    @Override
    public void setTabHighlighter(TabHighlighter tabHighlighter) {
        this.highlighter = tabHighlighter;
    }

    @Override
    protected void paintTabBorder(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        super.paintTabBorder(graphics, n, n2, n3, n4, n5, n6, bl);
        if (this.highlighter != null) {
            this.highlighter.paintTabBorder(graphics, n, n2, n3, n4, n5, n6, bl);
        }
    }

    @Override
    protected Insets getContentBorderInsets(int n) {
        return TabbedPaneUIFactory.getBorderLessInsets(n);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.selColor = UIManager.getColor("TabbedPane.selected");
    }

    @Override
    protected void paintContentBorder(Graphics graphics, int n, int n2) {
        int n3 = this.tabPane.getWidth();
        int n4 = this.tabPane.getHeight();
        Insets insets = this.tabPane.getInsets();
        int n5 = insets.left;
        int n6 = insets.top;
        int n7 = n3 - insets.right - insets.left;
        int n8 = n4 - insets.top - insets.bottom;
        switch (n) {
            case 2: {
                n7 -= (n5 += this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth)) - insets.left;
                break;
            }
            case 4: {
                n7 -= this.calculateTabAreaWidth(n, this.runCount, this.maxTabWidth);
                break;
            }
            case 3: {
                n8 -= this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight);
                break;
            }
            default: {
                n8 -= (n6 += this.calculateTabAreaHeight(n, this.runCount, this.maxTabHeight)) - insets.top;
            }
        }
        if (this.selColor == null) {
            graphics.setColor(this.tabPane.getBackground());
        } else {
            graphics.setColor(this.selColor);
        }
        graphics.fillRect(n5, n6, n7, n8);
        switch (n) {
            case 1: {
                this.paintContentBorderTopEdge(graphics, n, n2, n5, n6, n7, n8);
                break;
            }
            case 3: {
                this.paintContentBorderBottomEdge(graphics, n, n2, n5, n6, n7, n8);
                break;
            }
            case 2: {
                this.paintContentBorderLeftEdge(graphics, n, n2, n5, n6, n7, n8);
                break;
            }
            case 4: {
                this.paintContentBorderRightEdge(graphics, n, n2, n5, n6, n7, n8);
            }
        }
    }
}

