/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ColumnHider {
    private List<TableColumn> hiddenColumns;
    private TableColumnModel columnModel;

    public ColumnHider(TableColumnModel tableColumnModel) {
        this.columnModel = tableColumnModel;
        this.hiddenColumns = new ArrayList<TableColumn>(tableColumnModel.getColumnCount());
    }

    public void hideColumn(Object object) {
        if (this.isHidden(object)) {
            return;
        }
        int n = this.columnModel.getColumnIndex(object);
        if (n > -1) {
            TableColumn tableColumn = this.columnModel.getColumn(n);
            this.hiddenColumns.add(tableColumn);
            this.columnModel.removeColumn(tableColumn);
        }
    }

    public void showColumn(Object object) {
        TableColumn tableColumn = this.getHiddenColumn(object);
        if (tableColumn != null) {
            this.columnModel.addColumn(tableColumn);
        }
    }

    private boolean isHidden(Object object) {
        return this.getHiddenColumn(object) != null;
    }

    private TableColumn getHiddenColumn(Object object) {
        if (object == null) {
            return null;
        }
        for (TableColumn tableColumn : this.hiddenColumns) {
            Object object2 = tableColumn.getIdentifier();
            if (object2 == null || !tableColumn.getIdentifier().equals(object)) continue;
            return tableColumn;
        }
        return null;
    }
}

