/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.lang.reflect.Method;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import workbench.interfaces.SimplePropertyEditor;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class ComboStringPropertyEditor
extends JComboBox
implements ItemListener,
SimplePropertyEditor,
FocusListener,
DocumentListener {
    private Object source;
    private Method setter;
    private Method getter;
    protected boolean changed;
    private boolean immediateUpdate;
    private ActionListener listener;

    @Override
    public void setSourceObject(Object object, String string) {
        this.source = object;
        this.changed = false;
        String string2 = Character.toUpperCase(string.charAt(0)) + string.substring(1);
        this.stopEvents();
        try {
            String string3 = "get" + string2;
            Class<?> clazz = object.getClass();
            this.getter = clazz.getMethod(string3, null);
            string3 = "set" + string2;
            Class[] classArray = new Class[]{String.class};
            this.setter = clazz.getMethod(string3, classArray);
            if (this.getModel() != null) {
                this.initData();
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error during init", exception);
        }
        this.startEvents();
    }

    private ActionListener getListener() {
        if (this.listener == null) {
            this.listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ComboStringPropertyEditor.this.changed = true;
                    ComboStringPropertyEditor.this.applyChanges();
                }
            };
        }
        return this.listener;
    }

    private void stopEvents() {
        this.removeItemListener(this);
        if (this.isEditable()) {
            this.removeActionListener(this.getListener());
            JTextField jTextField = (JTextField)this.getEditor().getEditorComponent();
            jTextField.getDocument().removeDocumentListener(this);
        }
    }

    private void startEvents() {
        this.addItemListener(this);
        if (this.isEditable()) {
            this.addActionListener(this.getListener());
            JTextField jTextField = (JTextField)this.getEditor().getEditorComponent();
            jTextField.getDocument().addDocumentListener(this);
        }
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        this.stopEvents();
        super.setModel(comboBoxModel);
        if (this.isEditable()) {
            this.initData();
        }
        this.startEvents();
    }

    private void initData() {
        if (this.getter == null || this.source == null) {
            return;
        }
        try {
            Object object = this.getter.invoke(this.source, (Object[])null);
            this.setSelectedItem(object);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error", exception);
        }
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void applyChanges() {
        if (!this.changed) {
            return;
        }
        Object[] objectArray = new Object[]{this.isEditable() ? this.getEditor().getItem().toString() : this.getSelectedItem().toString()};
        try {
            this.setter.invoke(this.source, objectArray);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error during init", exception);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.changed = true;
        }
        if (this.immediateUpdate) {
            this.applyChanges();
        }
    }

    @Override
    public void setImmediateUpdate(boolean bl) {
        this.immediateUpdate = bl;
        if (bl) {
            this.applyChanges();
        }
    }

    @Override
    public boolean getImmediateUpdate() {
        return this.immediateUpdate;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.applyChanges();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.documentChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.documentChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.documentChanged();
    }

    private void documentChanged() {
        this.changed = true;
        this.applyChanges();
    }
}

