/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.ByteBufferTableModel;
import workbench.gui.components.LineNumberTable;
import workbench.gui.components.WbScrollPane;
import workbench.util.NumberStringCache;

public class HexPanel
extends JPanel {
    private JTable dataTable;
    private LineNumberTable lines;

    public HexPanel() {
        this.setBorder(WbSwingUtilities.EMPTY_BORDER);
        this.dataTable = new JTable();
        this.dataTable.setAutoCreateColumnsFromModel(true);
        this.dataTable.setCellSelectionEnabled(false);
        this.dataTable.setShowGrid(false);
        this.dataTable.setAutoResizeMode(0);
        Font font = new Font("Monospaced", 0, 12);
        this.dataTable.setFont(font);
        this.setLayout(new BorderLayout());
        this.lines = new LineNumberTable(this.dataTable);
        WbScrollPane wbScrollPane = new WbScrollPane(this.dataTable);
        wbScrollPane.setRowHeaderView(this.lines);
        JTableHeader jTableHeader = this.dataTable.getTableHeader();
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setBackground(new Color(238, 240, 238));
        jTableHeader.setDefaultRenderer(defaultTableCellRenderer);
        this.add((Component)jTableHeader, "North");
        this.add((Component)wbScrollPane, "Center");
    }

    public HexPanel(byte[] byArray) {
        this();
        this.setData(byArray);
    }

    public void setData(byte[] byArray) {
        Object object;
        ByteBufferTableModel byteBufferTableModel = new ByteBufferTableModel(byArray);
        this.dataTable.setModel(byteBufferTableModel);
        TableColumnModel tableColumnModel = this.dataTable.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        Font font = this.dataTable.getFont();
        FontMetrics fontMetrics = this.dataTable.getFontMetrics(font);
        int n2 = fontMetrics.stringWidth("000");
        for (int i = 0; i < n - 1; ++i) {
            object = tableColumnModel.getColumn(i);
            ((TableColumn)object).setPreferredWidth(n2);
            ((TableColumn)object).setMinWidth(n2);
            ((TableColumn)object).setMaxWidth(n2);
        }
        n2 = fontMetrics.stringWidth("MMMMMMMMMMMMMMMMM");
        TableColumn tableColumn = tableColumnModel.getColumn(n - 1);
        tableColumn.setPreferredWidth(n2);
        tableColumn.setMinWidth(n2);
        tableColumn.setMaxWidth(n2);
        object = NumberStringCache.getNumberString(byteBufferTableModel.getRowCount());
        n2 = fontMetrics.stringWidth((String)object);
        this.lines.setPreferredScrollableViewportSize(new Dimension(n2 + 5, 32768));
    }
}

