/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import workbench.db.ColumnIdentifier;
import workbench.db.TableIdentifier;
import workbench.gui.components.ColumnSelectorPanel;
import workbench.resource.ResourceMgr;
import workbench.storage.ResultInfo;

public class KeyColumnSelectorPanel
extends ColumnSelectorPanel {
    private ColumnIdentifier[] columns;
    private String tableName;
    private JCheckBox saveCheckBox;

    public KeyColumnSelectorPanel(ResultInfo resultInfo) {
        super(resultInfo.getColumns());
        TableIdentifier tableIdentifier = resultInfo.getUpdateTable();
        this.tableName = tableIdentifier == null ? "" : tableIdentifier.getTableName();
        this.setSelectionLabel(ResourceMgr.getString("LblHeaderKeyColumnPKFlag"));
        this.configureInfoPanel();
        this.doLayout();
        ColumnIdentifier[] columnIdentifierArray = resultInfo.getColumns();
        this.columns = new ColumnIdentifier[columnIdentifierArray.length];
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i] = columnIdentifierArray[i].createCopy();
            this.setColumnSelected(i, columnIdentifierArray[i].isPkColumn());
        }
        if (resultInfo.isUserDefinedPK()) {
            this.saveCheckBox.setSelected(true);
        }
    }

    @Override
    protected void configureInfoPanel() {
        if (this.tableName == null) {
            return;
        }
        String string = ResourceMgr.getString("MsgSelectKeyColumns").replace("%tablename%", this.tableName);
        JLabel jLabel = new JLabel(string);
        this.infoPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.infoPanel.add((Component)jLabel, gridBagConstraints);
        this.saveCheckBox = new JCheckBox(ResourceMgr.getString("LblRememberPKMapping"));
        this.saveCheckBox.setToolTipText(ResourceMgr.getDescription("LblRememberPKMapping"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        this.infoPanel.add((Component)this.saveCheckBox, gridBagConstraints);
    }

    public boolean getSaveToGlobalPKMap() {
        return this.saveCheckBox.isSelected();
    }

    public ColumnIdentifier[] getColumns() {
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i].setIsPkColumn(this.isColumnSelected(i));
        }
        return this.columns;
    }
}

