/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import workbench.gui.actions.DeleteListEntryAction;
import workbench.gui.actions.NewListEntryAction;
import workbench.gui.components.ColumnWidthOptimizer;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.WbTable;
import workbench.gui.components.WbToolbar;
import workbench.gui.renderer.RendererSetup;
import workbench.interfaces.FileActions;
import workbench.sql.VariablesDataStore;
import workbench.storage.DataStore;
import workbench.util.StringUtil;

public class MapEditor
extends JPanel
implements FileActions {
    private DataStore propData;
    private WbTable propTable;
    private NewListEntryAction newItem;
    private DeleteListEntryAction deleteItem;

    public MapEditor(Properties properties) {
        this.initUI();
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                int n = this.propData.addRow();
                this.propData.setValue(n, 0, (Object)string);
                this.propData.setValue(n, 1, (Object)string2);
            }
            this.propData.resetStatus();
            this.propTable.checkCopyActions();
        }
    }

    public MapEditor(Map<String, String> map) {
        this.initUI();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                int n = this.propData.addRow();
                this.propData.setValue(n, 0, (Object)entry.getKey());
                this.propData.setValue(n, 1, (Object)entry.getValue());
            }
            this.propData.resetStatus();
            this.propTable.checkCopyActions();
        }
    }

    public void setEditable(boolean bl) {
        this.newItem.setEnabled(bl);
        this.deleteItem.setEnabled(bl);
        this.propTable.setReadOnly(!bl);
    }

    public boolean isModified() {
        return this.propData.isModified();
    }

    private void initUI() {
        this.propData = this.createDataStore();
        this.propData.setAllowUpdates(true);
        this.propTable = new WbTable();
        this.propTable.setRendererSetup(new RendererSetup(false));
        this.propTable.setModel(new DataStoreTableModel(this.propData));
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.propTable);
        WbToolbar wbToolbar = new WbToolbar();
        wbToolbar.addDefaultBorder();
        this.newItem = new NewListEntryAction(this);
        this.deleteItem = new DeleteListEntryAction(this);
        wbToolbar.add(this.newItem);
        wbToolbar.add(this.deleteItem);
        this.add((Component)wbToolbar, "North");
        this.add((Component)jScrollPane, "Center");
        this.optimizeColumnWidths();
    }

    protected DataStore createDataStore() {
        return new VariablesDataStore();
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        properties.putAll(this.getMap());
        return properties;
    }

    public Map<String, String> getMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.propTable.stopEditing();
        int n = this.propData.getRowCount();
        for (int i = 0; i < n; ++i) {
            String string = this.propData.getValueAsString(i, 0);
            if (StringUtil.isEmptyString(string)) continue;
            String string2 = this.propData.getValueAsString(i, 1);
            hashMap.put(string.trim(), string2 == null ? "" : string2.trim());
        }
        return hashMap;
    }

    @Override
    public void deleteItem() throws Exception {
        this.propTable.deleteRow();
    }

    @Override
    public void newItem(boolean bl) {
        this.propTable.addRow();
        this.propTable.getSelectionModel().clearSelection();
    }

    @Override
    public void saveItem() throws Exception {
    }

    public void optimizeColumnWidths() {
        ColumnWidthOptimizer columnWidthOptimizer = new ColumnWidthOptimizer(this.propTable);
        columnWidthOptimizer.optimizeAllColWidth(true);
    }
}

