/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.lang.reflect.Method;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import workbench.interfaces.SimplePropertyEditor;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;

public class PasswordPropertyEditor
extends JPasswordField
implements DocumentListener,
SimplePropertyEditor,
FocusListener {
    private Object source;
    private Method setter;
    private Method getter;
    private boolean changed;
    private String propName;
    private boolean immediateUpdate;

    public PasswordPropertyEditor() {
        this.addFocusListener(this);
    }

    @Override
    public void setSourceObject(Object object, String string) {
        this.source = object;
        this.changed = false;
        this.propName = string;
        this.getDocument().removeDocumentListener(this);
        try {
            String string2 = "getDecryptedPassword";
            Class<?> clazz = object.getClass();
            this.getter = clazz.getMethod(string2, null);
            string2 = "setPassword";
            Class[] classArray = new Class[]{String.class};
            this.setter = clazz.getMethod(string2, classArray);
            String string3 = (String)this.getter.invoke(this.source, (Object[])null);
            this.setText(string3);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error during init", exception);
        }
        this.getDocument().addDocumentListener(this);
    }

    @Override
    public void applyChanges() {
        if (!this.changed) {
            return;
        }
        if (this.source == null) {
            return;
        }
        if (this.setter == null) {
            return;
        }
        Object[] objectArray = new Object[]{new String(this.getPassword())};
        try {
            this.setter.invoke(this.source, objectArray);
            this.changed = false;
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error applying changes", exception);
        }
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.changed = true;
        if (this.immediateUpdate) {
            this.applyChanges();
        }
        this.firePropertyChange(this.propName, null, null);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.changed = true;
        if (this.immediateUpdate) {
            this.applyChanges();
        }
        this.firePropertyChange(this.propName, null, null);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.changed = true;
        if (this.immediateUpdate) {
            this.applyChanges();
        }
        this.firePropertyChange(this.propName, null, null);
    }

    @Override
    public void setImmediateUpdate(boolean bl) {
        this.immediateUpdate = bl;
        if (bl) {
            this.applyChanges();
        }
    }

    @Override
    public boolean getImmediateUpdate() {
        return this.immediateUpdate;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (!this.immediateUpdate) {
            this.applyChanges();
        }
    }
}

