/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.gui.components.SelectTablePanel;
import workbench.gui.components.ValidatingDialog;
import workbench.gui.components.WbTable;
import workbench.resource.ResourceMgr;
import workbench.storage.DataStore;
import workbench.util.Alias;
import workbench.util.SqlUtil;

public class UpdateTableSelector {
    private WbTable tableData;

    public UpdateTableSelector(WbTable wbTable) {
        this.tableData = wbTable;
    }

    public TableIdentifier selectUpdateTable() {
        if (this.tableData == null) {
            return null;
        }
        DataStore dataStore = this.tableData.getDataStore();
        if (dataStore == null) {
            return null;
        }
        String string = dataStore.getGeneratingSql();
        WbConnection wbConnection = dataStore.getOriginalConnection();
        List<Alias> list = SqlUtil.getTables(string, false, wbConnection);
        TableIdentifier tableIdentifier = null;
        if (list.size() > 1) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (Alias alias : list) {
                arrayList.add(alias.getObjectName());
            }
            SelectTablePanel selectTablePanel = new SelectTablePanel(arrayList);
            boolean bl = ValidatingDialog.showConfirmDialog(SwingUtilities.getWindowAncestor(this.tableData), selectTablePanel, ResourceMgr.getString("MsgSelectTableTitle"));
            String string2 = null;
            if (bl) {
                string2 = selectTablePanel.getSelectedTable();
            }
            if (string2 != null) {
                tableIdentifier = new TableIdentifier(string2, wbConnection);
            }
        } else if (list.size() == 1 && (tableIdentifier = dataStore.getUpdateTable()) == null) {
            tableIdentifier = new TableIdentifier(list.get(0).getObjectName(), wbConnection);
        }
        return tableIdentifier;
    }
}

