/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.border.Border;
import workbench.WbManager;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.EscAction;
import workbench.gui.actions.WbAction;
import workbench.gui.components.WbButton;
import workbench.interfaces.ValidatingComponent;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;

public class ValidatingDialog
extends JDialog
implements WindowListener,
ActionListener,
PropertyChangeListener {
    public static final String PROPERTY_VALID_STATE = "editorValid";
    protected ValidatingComponent validator;
    protected JComponent editorComponent;
    private JButton[] optionButtons;
    private JButton cancelButton;
    private boolean isCancelled = true;
    private int selectedOption = -1;
    private EscAction esc;
    private JPanel buttonPanel;

    public ValidatingDialog(Dialog dialog, String string, JComponent jComponent) {
        super(dialog, string, true);
        this.init(jComponent, new String[]{ResourceMgr.getString("LblOK")}, true);
    }

    public ValidatingDialog(Frame frame, String string, JComponent jComponent) {
        this(frame, string, jComponent, true);
    }

    public ValidatingDialog(Frame frame, String string, JComponent jComponent, boolean bl) {
        super(frame, string, true);
        this.init(jComponent, new String[]{ResourceMgr.getString("LblOK")}, bl);
    }

    public ValidatingDialog(Frame frame, String string, JComponent jComponent, String[] stringArray, boolean bl) {
        super(frame, string, bl);
        this.init(jComponent, stringArray, false);
    }

    public ValidatingDialog(Dialog dialog, String string, JComponent jComponent, boolean bl) {
        super(dialog, string, true);
        this.init(jComponent, new String[]{ResourceMgr.getString("LblOK")}, bl);
    }

    public ValidatingDialog(Dialog dialog, String string, JComponent jComponent, String[] stringArray) {
        this(dialog, string, jComponent, stringArray, true);
    }

    public ValidatingDialog(Dialog dialog, String string, JComponent jComponent, String[] stringArray, boolean bl) {
        super(dialog, string, true);
        this.init(jComponent, stringArray, bl);
    }

    public void setDefaultButton(int n) {
        JRootPane jRootPane = this.getRootPane();
        if (n >= this.optionButtons.length && this.cancelButton != null) {
            jRootPane.setDefaultButton(this.cancelButton);
        } else {
            jRootPane.setDefaultButton(this.optionButtons[n]);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Boolean bl;
        if (propertyChangeEvent.getSource() == this.editorComponent && PROPERTY_VALID_STATE.equals(propertyChangeEvent.getPropertyName()) && (bl = (Boolean)propertyChangeEvent.getNewValue()) != null) {
            this.setButtonsEnabled(bl);
        }
    }

    public void setButtonsEnabled(boolean bl) {
        if (this.validator == null) {
            return;
        }
        for (JButton jButton : this.optionButtons) {
            jButton.setEnabled(bl);
        }
    }

    private void init(JComponent jComponent, String[] stringArray, boolean bl) {
        Object object;
        if (jComponent instanceof ValidatingComponent) {
            this.validator = (ValidatingComponent)((Object)jComponent);
        }
        this.editorComponent = jComponent;
        this.editorComponent.addPropertyChangeListener(PROPERTY_VALID_STATE, this);
        this.optionButtons = new JButton[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.optionButtons[i] = new WbButton(stringArray[i]);
            object = this.optionButtons[i].getText();
            if (((String)object).equals("OK")) {
                this.optionButtons[i].setName("ok");
            }
            this.optionButtons[i].addActionListener(this);
        }
        if (bl) {
            this.cancelButton = new WbButton(ResourceMgr.getString("LblCancel"));
            this.cancelButton.setName("cancel");
            this.cancelButton.addActionListener(this);
        }
        JRootPane jRootPane = this.getRootPane();
        jRootPane.setDefaultButton(this.optionButtons[0]);
        this.esc = new EscAction(this, this);
        object = new JPanel();
        ((Container)object).setLayout(new BorderLayout());
        int n = (int)((double)IconMgr.getInstance().getSizeForLabel() * 0.7);
        Border border = BorderFactory.createEmptyBorder(n, n, n, n);
        ((JComponent)object).setBorder(border);
        ((Container)object).add((Component)jComponent, "Center");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout(2, 0, 0));
        int n2 = this.optionButtons.length + (this.cancelButton == null ? 0 : 1);
        JComponent[] jComponentArray = new JComponent[n2];
        for (int i = 0; i < this.optionButtons.length; ++i) {
            if (i > 0) {
                this.buttonPanel.add(Box.createHorizontalStrut(n));
            }
            this.buttonPanel.add(this.optionButtons[i]);
            jComponentArray[i] = this.optionButtons[i];
        }
        if (this.cancelButton != null) {
            this.buttonPanel.add(Box.createHorizontalStrut(n));
            this.buttonPanel.add(this.cancelButton);
            jComponentArray[jComponentArray.length - 1] = this.cancelButton;
        }
        border = BorderFactory.createEmptyBorder(n, 0, 0, 0);
        WbSwingUtilities.makeEqualWidth(jComponentArray);
        this.buttonPanel.setBorder(border);
        ((Container)object).add((Component)this.buttonPanel, "South");
        this.getContentPane().add((Component)object);
        this.doLayout();
        this.pack();
        this.addWindowListener(this);
    }

    public void setButtonEnabled(int n, boolean bl) {
        if (n >= 0 && n < this.optionButtons.length) {
            this.optionButtons[n].setEnabled(bl);
        }
    }

    public WbAction getESCAction() {
        return this.esc;
    }

    public int getSelectedOption() {
        return this.selectedOption;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public static boolean showConfirmDialog(Window window, JComponent jComponent, String string) {
        return ValidatingDialog.showConfirmDialog(window, jComponent, string, null, 0, false);
    }

    public static boolean showOKCancelDialog(Dialog dialog, JComponent jComponent, String string) {
        ValidatingDialog validatingDialog = new ValidatingDialog(dialog, string, jComponent, true);
        WbSwingUtilities.center(validatingDialog, dialog);
        validatingDialog.setDefaultButton(0);
        validatingDialog.setVisible(true);
        return !validatingDialog.isCancelled();
    }

    public static boolean showConfirmDialog(Window window, JComponent jComponent, String string, int n) {
        return ValidatingDialog.showConfirmDialog(window, jComponent, string, null, n, false);
    }

    public static ValidatingDialog createDialog(Window window, JComponent jComponent, String string, Component component, int n, boolean bl) {
        ValidatingDialog validatingDialog = null;
        if (window == null) {
            validatingDialog = new ValidatingDialog((Frame)WbManager.getInstance().getCurrentWindow(), string, jComponent);
        } else if (window instanceof Frame) {
            validatingDialog = new ValidatingDialog((Frame)window, string, jComponent);
        } else if (window instanceof Dialog) {
            validatingDialog = new ValidatingDialog((Dialog)window, string, jComponent);
        } else {
            throw new IllegalArgumentException("Parent component must be Dialog or Frame");
        }
        validatingDialog.pack();
        if (component != null) {
            WbSwingUtilities.center(validatingDialog, component);
        } else {
            WbSwingUtilities.center(validatingDialog, window);
        }
        validatingDialog.setDefaultButton(n);
        if (bl) {
            validatingDialog.buttonPanel.setLayout(new FlowLayout(1));
        }
        return validatingDialog;
    }

    public static boolean showConfirmDialog(Window window, JComponent jComponent, String string, Component component, int n, boolean bl) {
        ValidatingDialog validatingDialog = ValidatingDialog.createDialog(window, jComponent, string, component, n, bl);
        validatingDialog.setVisible(true);
        return !validatingDialog.isCancelled();
    }

    public void close() {
        if (this.validator != null) {
            this.validator.componentWillBeClosed();
        }
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        if (this.validator == null) {
            this.editorComponent.requestFocusInWindow();
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.close();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        EventQueue.invokeLater(() -> {
            if (this.validator != null) {
                this.validator.componentDisplayed();
            } else {
                this.editorComponent.requestFocus();
            }
        });
    }

    public void approveAndClose() {
        this.selectedOption = 0;
        this.isCancelled = false;
        this.close();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.cancelButton || actionEvent.getSource() == this.esc) {
            this.selectedOption = -1;
            this.isCancelled = true;
            this.close();
        } else {
            for (int i = 0; i < this.optionButtons.length; ++i) {
                if (actionEvent.getSource() != this.optionButtons[i]) continue;
                this.selectedOption = i;
                break;
            }
            if (this.validator == null || this.validator.validateInput()) {
                this.isCancelled = false;
                this.close();
            }
        }
    }
}

