/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.FlatButton;
import workbench.gui.components.StringPropertyEditor;
import workbench.gui.components.TextComponentMouseListener;
import workbench.gui.components.WbFileChooser;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.util.ExceptionUtil;
import workbench.util.StringUtil;

public class WbFilePicker
extends JPanel {
    public static final String PROP_FILENAME = "filename";
    private String lastDir;
    private FileFilter fileFilter;
    private boolean allowMultiple;
    private File[] selectedFiles;
    private String lastDirProperty;
    private boolean selectDirectory;
    private boolean showSaveAsDialog;
    private JButton selectFileButton;
    private JTextField tfFilename;

    public WbFilePicker() {
        this(false);
    }

    public WbFilePicker(boolean bl) {
        this.showSaveAsDialog = bl;
        this.initComponents();
        WbSwingUtilities.adjustButtonWidth(this.selectFileButton, 22, 22);
    }

    public void setSelectDirectoryOnly(boolean bl) {
        this.selectDirectory = bl;
    }

    public void setSelectedFile(File file) {
        if (file != null) {
            this.selectedFiles = new File[]{file};
            this.tfFilename.setText(file.toString());
        }
    }

    public boolean getSelectDirectoryOnly() {
        return this.selectDirectory;
    }

    public void setTextFieldPropertyName(String string) {
        this.tfFilename.setName(string);
    }

    public void setTextfieldTooltip(String string) {
        this.tfFilename.setToolTipText(string);
    }

    public void setButtonTooltip(String string) {
        this.selectFileButton.setToolTipText(string);
    }

    public void setLastDirProperty(String string) {
        this.lastDirProperty = string;
        this.lastDir = Settings.getInstance().getProperty(string, null);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.tfFilename.setEnabled(bl);
        this.selectFileButton.setEnabled(bl);
    }

    @Override
    public void setToolTipText(String string) {
        super.setToolTipText(string);
        this.tfFilename.setToolTipText(string);
        this.selectFileButton.setToolTipText(string);
    }

    public void addActionListener(ActionListener actionListener) {
        this.tfFilename.addActionListener(actionListener);
    }

    private void initComponents() {
        this.tfFilename = new StringPropertyEditor();
        this.selectFileButton = new FlatButton();
        this.setLayout(new GridBagLayout());
        this.tfFilename.setColumns(10);
        this.tfFilename.setHorizontalAlignment(2);
        this.tfFilename.setName("library");
        this.tfFilename.addMouseListener(new TextComponentMouseListener());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.tfFilename, gridBagConstraints);
        this.selectFileButton.setText("...");
        this.selectFileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WbFilePicker.this.selectFileButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        this.add((Component)this.selectFileButton, gridBagConstraints);
    }

    private void selectFileButtonActionPerformed(ActionEvent actionEvent) {
        try {
            WbFileChooser wbFileChooser = new WbFileChooser();
            if (this.selectDirectory) {
                wbFileChooser.setFileSelectionMode(1);
            } else {
                wbFileChooser.setFileSelectionMode(0);
                wbFileChooser.setMultiSelectionEnabled(this.allowMultiple);
                if (this.lastDir != null) {
                    wbFileChooser.setCurrentDirectory(new File(this.lastDir));
                }
                if (this.fileFilter != null) {
                    wbFileChooser.setFileFilter(this.fileFilter);
                }
            }
            int n = 1;
            n = this.showSaveAsDialog ? wbFileChooser.showSaveDialog(SwingUtilities.getWindowAncestor(this)) : wbFileChooser.showOpenDialog(SwingUtilities.getWindowAncestor(this));
            if (n == 0) {
                if (this.allowMultiple) {
                    this.selectedFiles = wbFileChooser.getSelectedFiles();
                } else {
                    this.selectedFiles = new File[1];
                    this.selectedFiles[0] = wbFileChooser.getSelectedFile();
                }
                StringBuilder stringBuilder = new StringBuilder(this.selectedFiles.length * 100);
                for (int i = 0; i < this.selectedFiles.length; ++i) {
                    if (this.selectedFiles.length > 1 && i > 0) {
                        stringBuilder.append(StringUtil.getPathSeparator());
                    }
                    stringBuilder.append(this.selectedFiles[i].getAbsolutePath().trim());
                }
                String string = stringBuilder.toString();
                String string2 = this.tfFilename.getText();
                this.tfFilename.setText(string);
                if (this.lastDirProperty != null) {
                    Settings.getInstance().setProperty(this.lastDirProperty, this.selectedFiles[0].getParent());
                }
                this.firePropertyChange(PROP_FILENAME, string2, string);
            }
        }
        catch (Throwable throwable) {
            LogMgr.logError(new CallerInfo(){}, "Error selecting file", throwable);
            WbSwingUtilities.showErrorMessage(ExceptionUtil.getDisplay(throwable));
        }
    }

    public String getFilename() {
        return this.tfFilename.getText();
    }

    public void setFilename(String string) {
        this.tfFilename.setText(string != null ? string : "");
        this.tfFilename.setCaretPosition(0);
    }

    public File getSelectedFile() {
        if (this.selectedFiles == null) {
            if (StringUtil.isNonBlank(this.getFilename())) {
                return new File(this.getFilename());
            }
            return null;
        }
        return this.selectedFiles[0];
    }

    public File[] getSelectedFiles() {
        if (!this.allowMultiple) {
            return null;
        }
        return this.selectedFiles;
    }

    public void setAllowMultiple(boolean bl) {
        this.allowMultiple = bl;
    }

    public void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }
}

