/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.FlatButton;
import workbench.gui.components.ValidatingDialog;
import workbench.gui.components.WbFontChooser;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;

public class WbFontPicker
extends JPanel
implements Serializable {
    private JLabel fontName;
    private JButton resetButton;
    private JButton selectFontButton;
    private Font selectedFont;
    private boolean monospacedOnly;

    public WbFontPicker() {
        this.initComponents();
        this.setAllowFontReset(false);
    }

    public void setAllowFontReset(boolean bl) {
        this.resetButton.setVisible(bl);
        this.resetButton.setEnabled(bl);
        if (bl) {
            this.resetButton.setIcon(IconMgr.getInstance().getLabelIcon("Delete"));
            WbSwingUtilities.makeEqualSize(this.resetButton, this.selectFontButton);
        }
    }

    public void setListMonospacedOnly(boolean bl) {
        this.monospacedOnly = bl;
    }

    private void initComponents() {
        this.fontName = new JLabel();
        this.selectFontButton = new FlatButton();
        this.resetButton = new FlatButton();
        this.setLayout(new GridBagLayout());
        this.fontName.setText("Sample Font");
        this.fontName.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(1, 5, 1, 5)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.fontName, gridBagConstraints);
        this.resetButton.setToolTipText(ResourceMgr.getDescription("LblResetFont"));
        this.resetButton.addActionListener(this::resetButtonActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.add((Component)this.resetButton, gridBagConstraints);
        this.selectFontButton.setText("...");
        this.selectFontButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                WbFontPicker.this.selectFontButtonMouseClicked(mouseEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.selectFontButton, gridBagConstraints);
    }

    private void resetButtonActionPerformed(ActionEvent actionEvent) {
        this.setSelectedFont(null);
    }

    private void selectFontButtonMouseClicked(MouseEvent mouseEvent) {
        boolean bl;
        WbFontChooser wbFontChooser = new WbFontChooser(this.monospacedOnly);
        wbFontChooser.setSelectedFont(this.getSelectedFont());
        Dimension dimension = new Dimension(320, 240);
        wbFontChooser.setSize(dimension);
        wbFontChooser.setPreferredSize(dimension);
        Font font = null;
        JDialog jDialog = null;
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof JDialog) {
            jDialog = (JDialog)window;
        }
        if (bl = ValidatingDialog.showOKCancelDialog(jDialog, wbFontChooser, ResourceMgr.getString("TxtWindowTitleChooseFont"))) {
            font = wbFontChooser.getSelectedFont();
            this.setSelectedFont(font);
        }
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    public void setSelectedFont(Font font) {
        this.selectedFont = font;
        if (font == null) {
            Font font2 = UIManager.getDefaults().getFont("Label.font");
            this.fontName.setFont(font2);
            this.fontName.setText(ResourceMgr.getString("LblDefaultIndicator"));
        } else {
            this.fontName.setFont(font);
            this.fontName.setText(font.getFontName() + ", " + font.getSize());
        }
    }
}

