/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.FlatButton;
import workbench.gui.components.FontStyleComboBoxModel;
import workbench.gui.editor.SyntaxStyle;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;

public class WbFontStylePicker
extends JPanel
implements Serializable {
    private JComboBox<String> fontStyle;
    private JPanel infoPanel;
    private JLabel sampleColor;
    private JButton selectColorButton;

    public WbFontStylePicker() {
        this.initComponents();
        this.fontStyle.setModel(new FontStyleComboBoxModel());
        int n = IconMgr.getInstance().getSizeForLabel();
        int n2 = (int)((double)n * 1.5);
        WbSwingUtilities.adjustButtonWidth(this.selectColorButton, n2, n2);
        Dimension dimension = new Dimension((int)((double)n2 * 0.9), (int)((double)n2 * 0.9));
        this.setButtonSize(this.sampleColor, dimension);
        this.sampleColor.setOpaque(true);
        this.sampleColor.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
    }

    public int getFontStyle() {
        return this.fontStyle.getSelectedIndex();
    }

    public void setFontStyle(int n) {
        if (n < 0 || n > 3) {
            return;
        }
        this.fontStyle.setSelectedIndex(n);
    }

    private void setButtonSize(JComponent jComponent, Dimension dimension) {
        jComponent.setPreferredSize(dimension);
        jComponent.setMaximumSize(dimension);
        jComponent.setMinimumSize(dimension);
    }

    private void initComponents() {
        this.infoPanel = new JPanel();
        this.sampleColor = new JLabel();
        this.selectColorButton = new FlatButton();
        this.fontStyle = new JComboBox();
        this.setLayout(new FlowLayout(0, 0, 0));
        this.infoPanel.setLayout(new FlowLayout(1, 5, 0));
        this.sampleColor.setMinimumSize(new Dimension(16, 16));
        this.sampleColor.setPreferredSize(new Dimension(16, 16));
        this.infoPanel.add(this.sampleColor);
        this.selectColorButton.setText("...");
        this.selectColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                WbFontStylePicker.this.selectColorButtonActionPerformed(actionEvent);
            }
        });
        this.infoPanel.add(this.selectColorButton);
        this.add(this.infoPanel);
        this.fontStyle.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.add(this.fontStyle);
    }

    private void selectColorButtonActionPerformed(ActionEvent actionEvent) {
        Color color = JColorChooser.showDialog(SwingUtilities.getWindowAncestor(this), ResourceMgr.getString("TxtSelectColor"), this.getSelectedColor());
        if (color != null) {
            this.setSelectedColor(color);
        }
    }

    public void setStyle(SyntaxStyle syntaxStyle) {
        if (syntaxStyle == null) {
            return;
        }
        this.setSelectedColor(syntaxStyle.getColor());
        this.fontStyle.setSelectedIndex(syntaxStyle.getFontStyle());
    }

    public void setSelectedColor(Color color) {
        if (color != null) {
            this.sampleColor.setBackground(color);
        }
    }

    public Color getSelectedColor() {
        return this.sampleColor.getBackground();
    }
}

