/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.components;

import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JToolTip;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.WbAction;
import workbench.gui.components.MultiLineToolTip;
import workbench.gui.components.WbButton;
import workbench.gui.lnf.LnFHelper;
import workbench.resource.Settings;

public class WbToolbarButton
extends WbButton
implements PropertyChangeListener {
    public static final Insets SMALL_MARGIN = new Insets(1, 1, 1, 1);
    public static final Insets WIDE_MARGIN = new Insets(5, 5, 5, 5);
    private static final boolean USE_WIDE_MARGIN = LnFHelper.isFlatLaf();

    public WbToolbarButton() {
        this.init();
    }

    public WbToolbarButton(String string) {
        super(string);
        this.init();
    }

    public WbToolbarButton(Action action) {
        super(action);
        this.setText(null);
        this.iconButton = true;
        this.init();
    }

    public WbToolbarButton(Icon icon) {
        super(icon);
        this.setText(null);
        this.init();
    }

    public void setAction(WbAction wbAction) {
        super.setAction(wbAction);
        if (wbAction.getIconKey() != null || wbAction.hasCustomIcon()) {
            this.setText(null);
        }
        this.init();
    }

    private void removeListener() {
        Settings.getInstance().removePropertyChangeListener(this);
    }

    private void init() {
        this.setMargin(USE_WIDE_MARGIN ? WIDE_MARGIN : SMALL_MARGIN);
        this.setFocusable(false);
        if (this.getAction() instanceof WbAction) {
            Settings.getInstance().addPropertyChangeListener(this, ((WbAction)this.getAction()).getCustomIconProperty(), new String[0]);
        } else {
            this.removeListener();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.getAction() instanceof WbAction) {
            WbAction wbAction = (WbAction)this.getAction();
            this.configurePropertiesFromAction(wbAction);
            if (wbAction.getIconKey() != null || wbAction.hasCustomIcon()) {
                this.setText(null);
            }
            this.invalidate();
            WbSwingUtilities.repaintLater(this.getParent());
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeListener();
    }

    @Override
    public JToolTip createToolTip() {
        MultiLineToolTip multiLineToolTip = new MultiLineToolTip();
        multiLineToolTip.setComponent(this);
        return multiLineToolTip;
    }
}

