/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyListener;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import workbench.db.search.ClientSideTableSearcher;
import workbench.db.search.TableDataSearcher;
import workbench.gui.components.TextComponentMouseListener;
import workbench.gui.dbobjects.TableSearchCriteriaGUI;
import workbench.gui.filter.ComparatorListItem;
import workbench.gui.filter.ListComboBoxModel;
import workbench.interfaces.PropertyStorage;
import workbench.resource.ResourceMgr;
import workbench.storage.filter.ColumnComparator;
import workbench.storage.filter.ContainsComparator;
import workbench.storage.filter.RegExComparator;
import workbench.storage.filter.StartsWithComparator;
import workbench.storage.filter.StringEqualsComparator;
import workbench.util.CollectionUtil;
import workbench.util.StringUtil;

public class ClientSideTableSearchPanel
extends JPanel
implements TableSearchCriteriaGUI {
    private JTextField searchText;
    private JCheckBox ignoreCase;
    private JComboBox comparatorDropDown;
    private ClientSideTableSearcher searcher;

    public ClientSideTableSearchPanel() {
        super(new GridBagLayout());
        this.initComponents();
        this.searcher = new ClientSideTableSearcher();
    }

    private void initComponents() {
        JLabel jLabel = new JLabel();
        jLabel.setText(ResourceMgr.getString("LblSearchTableTxtCriteria"));
        String string = ResourceMgr.getDescription("LblSearchTableTxtCriteria");
        jLabel.setToolTipText(string);
        this.searchText = new JTextField();
        TextComponentMouseListener.addListener(this.searchText);
        this.searchText.setToolTipText(string);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.add((Component)jLabel, gridBagConstraints);
        this.comparatorDropDown = new JComboBox();
        List<ComparatorListItem> list = CollectionUtil.arrayList();
        list.add(new ComparatorListItem(new ContainsComparator()));
        list.add(new ComparatorListItem(new StartsWithComparator()));
        list.add(new ComparatorListItem(new StringEqualsComparator()));
        list.add(new ComparatorListItem(new RegExComparator()));
        ListComboBoxModel listComboBoxModel = new ListComboBoxModel(list);
        this.comparatorDropDown.setModel(listComboBoxModel);
        this.comparatorDropDown.setSelectedIndex(0);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 5);
        this.add((Component)this.comparatorDropDown, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 5);
        this.add((Component)this.searchText, gridBagConstraints);
        this.ignoreCase = new JCheckBox(ResourceMgr.getString("LblFilterIgnoreCase"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 2);
        this.add((Component)this.ignoreCase, gridBagConstraints);
    }

    private ColumnComparator getComparator() {
        ComparatorListItem comparatorListItem = (ComparatorListItem)this.comparatorDropDown.getSelectedItem();
        return comparatorListItem.getComparator();
    }

    @Override
    public void disableControls() {
        this.searchText.setEnabled(false);
        this.comparatorDropDown.setEnabled(false);
    }

    @Override
    public void enableControls() {
        this.searchText.setEnabled(true);
        this.comparatorDropDown.setEnabled(true);
    }

    @Override
    public TableDataSearcher getSearcher() {
        this.searcher.setComparator(this.getComparator());
        this.searcher.setCriteria(this.searchText.getText(), this.ignoreCase.isSelected());
        return this.searcher;
    }

    @Override
    public void saveSettings(String string, PropertyStorage propertyStorage) {
        propertyStorage.setProperty(string + ".clientsearch.criteria", this.searchText.getText());
        propertyStorage.setProperty(string + ".clientsearch.comparator", this.getComparator().getClass().getName());
        propertyStorage.setProperty(string + ".clientsearch.ignorecase", this.ignoreCase.isSelected());
    }

    @Override
    public void restoreSettings(String string, PropertyStorage propertyStorage) {
        this.searchText.setText(propertyStorage.getProperty(string + ".clientsearch.criteria", ""));
        this.ignoreCase.setSelected(propertyStorage.getBoolProperty(string + ".clientsearch.ignorecase", true));
        String string2 = propertyStorage.getProperty(string + ".clientsearch.comparator", null);
        if (StringUtil.isNonBlank(string2)) {
            int n = this.comparatorDropDown.getItemCount();
            for (int i = 0; i < n; ++i) {
                ComparatorListItem comparatorListItem = (ComparatorListItem)this.comparatorDropDown.getItemAt(i);
                ColumnComparator columnComparator = comparatorListItem.getComparator();
                if (!columnComparator.getClass().getName().equals(string2)) continue;
                this.comparatorDropDown.setSelectedIndex(i);
            }
        }
    }

    @Override
    public void addKeyListenerForCriteria(KeyListener keyListener) {
        this.searchText.addKeyListener(keyListener);
    }
}

