/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import workbench.db.DbObject;
import workbench.db.PackageDefinition;
import workbench.db.ProcedureDefinition;
import workbench.db.WbConnection;
import workbench.db.dependency.DependencyReader;
import workbench.db.dependency.DependencyReaderFactory;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.ReloadAction;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.WbSplitPane;
import workbench.gui.components.WbTable;
import workbench.gui.components.WbToolbar;
import workbench.interfaces.Reloadable;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.storage.DataStore;
import workbench.util.WbThread;

public class ObjectDependencyPanel
extends JPanel
implements Reloadable {
    private DbObject currentObject;
    private ReloadAction reload;
    private WbConnection dbConnection;
    private DependencyReader reader;
    private JScrollPane usedScroll;
    private WbTable objectsUsed = new WbTable(false, false, false);
    private WbTable usedByObjects = new WbTable(false, false, false);
    private boolean isRetrieving;
    private WbSplitPane split = new WbSplitPane(0);
    private JLabel usingLabel;
    private JLabel usedByLabel;

    public ObjectDependencyPanel() {
        super(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        this.usingLabel = this.createTitleLabel("TxtDepsUses");
        jPanel.add((Component)this.usingLabel, "First");
        this.usedScroll = new JScrollPane(this.objectsUsed);
        jPanel.add((Component)this.usedScroll, "Center");
        this.split.setTopComponent(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.usedByLabel = this.createTitleLabel("TxtDepsUsedBy");
        jPanel2.add((Component)this.usedByLabel, "First");
        JScrollPane jScrollPane = new JScrollPane(this.usedByObjects);
        jPanel2.add((Component)jScrollPane, "Center");
        this.split.setBottomComponent(jPanel2);
        this.split.setDividerLocation(150);
        this.split.setDividerSize(IconMgr.getInstance().getSizeForLabel() / 2);
        this.split.setDividerBorder(new EmptyBorder(0, 0, 0, 0));
        this.add((Component)this.split, "Center");
        this.reload = new ReloadAction(this);
        this.reload.setEnabled(false);
        WbToolbar wbToolbar = new WbToolbar();
        wbToolbar.add(this.reload);
        this.add((Component)wbToolbar, "First");
    }

    private JLabel createTitleLabel(String string) {
        JLabel jLabel = new JLabel(ResourceMgr.getString(string));
        jLabel.setOpaque(true);
        jLabel.setBackground(Color.WHITE);
        jLabel.setIconTextGap(IconMgr.getInstance().getSizeForLabel() / 2);
        jLabel.setHorizontalTextPosition(10);
        Font font = jLabel.getFont();
        Font font2 = font.deriveFont(1);
        FontMetrics fontMetrics = jLabel.getFontMetrics(font2);
        int n = fontMetrics.getHeight();
        int n2 = n / 3;
        int n3 = n / 5;
        jLabel.setBorder(new CompoundBorder(new EtchedBorder(1), new EmptyBorder(n2, n3, n2, n3)));
        jLabel.setFont(font2);
        return jLabel;
    }

    public void dispose() {
        if (this.objectsUsed != null) {
            this.objectsUsed.dispose();
        }
        if (this.usedByObjects != null) {
            this.usedByObjects.dispose();
        }
    }

    public void setCurrentObject(DbObject dbObject) {
        this.currentObject = dbObject;
        this.reset();
        this.checkPackage();
    }

    private void checkPackage() {
        ProcedureDefinition procedureDefinition;
        if (this.currentObject instanceof ProcedureDefinition && (procedureDefinition = (ProcedureDefinition)this.currentObject).isPackageProcedure()) {
            this.currentObject = new PackageDefinition(procedureDefinition.getSchema(), procedureDefinition.getPackageName());
        }
    }

    public void setConnection(WbConnection wbConnection) {
        this.reset();
        this.dbConnection = wbConnection;
        this.reader = DependencyReaderFactory.getReader(this.dbConnection);
        this.reload.setEnabled(true);
    }

    public void reset() {
        this.objectsUsed.reset();
        this.usedByObjects.reset();
    }

    public void cancel() {
    }

    @Override
    public void reload() {
        this.reset();
        if (!WbSwingUtilities.isConnectionIdle(this, this.dbConnection)) {
            return;
        }
        WbThread wbThread = new WbThread(this::doLoad, "DependencyLoader Thread");
        wbThread.start();
    }

    public void doLoad() {
        if (this.reader == null) {
            return;
        }
        if (this.isRetrieving) {
            return;
        }
        try {
            this.isRetrieving = true;
            this.reload.setEnabled(false);
            WbSwingUtilities.showWaitCursor(this);
            List<DbObject> list = this.reader.getUsedObjects(this.dbConnection, this.currentObject);
            EventQueue.invokeLater(() -> this.showResult(list, this.objectsUsed));
            List<DbObject> list2 = this.reader.getUsedBy(this.dbConnection, this.currentObject);
            EventQueue.invokeLater(() -> {
                this.showResult(list2, this.usedByObjects);
                this.invalidate();
            });
            EventQueue.invokeLater(this::calculateSplit);
        }
        finally {
            WbSwingUtilities.showDefaultCursor(this);
            this.reload.setEnabled(true);
            this.isRetrieving = false;
        }
    }

    private void calculateSplit() {
        this.invalidate();
        int n = Math.max(this.objectsUsed.getRowCount() + 2, 5);
        int n2 = (int)((double)(this.objectsUsed.getRowHeight() * n) * 1.1);
        int n3 = this.getHeight() / 5;
        this.split.setDividerLocation(Math.max(n3, n2));
        this.doLayout();
    }

    private void showResult(List<DbObject> list, WbTable wbTable) {
        DataStore dataStore = this.dbConnection.getMetadata().createTableListDataStore();
        for (DbObject dbObject : list) {
            int n = dataStore.addRow();
            dataStore.setValue(n, 2, (Object)dbObject.getCatalog());
            dataStore.setValue(n, 3, (Object)dbObject.getSchema());
            dataStore.setValue(n, 0, (Object)dbObject.getObjectName());
            dataStore.setValue(n, 1, (Object)dbObject.getObjectType());
            dataStore.setValue(n, 4, (Object)dbObject.getComment());
        }
        dataStore.resetStatus();
        DataStoreTableModel dataStoreTableModel = new DataStoreTableModel(dataStore);
        wbTable.setModel(dataStoreTableModel, true);
    }
}

