/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.CreateSnippetAction;
import workbench.gui.actions.OpenFileAction;
import workbench.gui.components.WbStatusLabel;
import workbench.gui.sql.EditorPanel;
import workbench.interfaces.ScriptGenerationMonitor;
import workbench.interfaces.Scripter;
import workbench.interfaces.TextOutput;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.util.StringUtil;
import workbench.util.WbThread;

public class ObjectScripterUI
extends JPanel
implements WindowListener,
ScriptGenerationMonitor,
TextOutput {
    protected Scripter scripter;
    protected JLabel statusMessage;
    protected EditorPanel editor;
    protected JFrame window;
    private boolean isRunning;
    private final Object runMonitor = new Object();
    private String mainObject;

    public ObjectScripterUI(Scripter scripter) {
        super(new BorderLayout());
        this.scripter = scripter;
        this.scripter.setProgressMonitor(this);
        this.scripter.setTextOutput(this);
        this.statusMessage = new WbStatusLabel();
        this.add((Component)this.statusMessage, "South");
        this.editor = EditorPanel.createSqlEditor();
        OpenFileAction openFileAction = this.editor.getOpenFileAction();
        this.editor.removePopupMenuItem(openFileAction);
        this.editor.showFormatSql();
        this.editor.setAllowReformatOnReadonly(true);
        openFileAction.setEnabled(false);
        CreateSnippetAction createSnippetAction = new CreateSnippetAction(this.editor);
        this.editor.addPopupMenuItem(createSnippetAction, true);
        this.add((Component)this.editor, "Center");
    }

    public void setDbConnection(WbConnection wbConnection) {
        this.editor.setDatabaseConnection(wbConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRunning(boolean bl) {
        Object object = this.runMonitor;
        synchronized (object) {
            this.isRunning = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRunning() {
        Object object = this.runMonitor;
        synchronized (object) {
            return this.isRunning;
        }
    }

    @Override
    public void append(CharSequence charSequence) {
        if (charSequence == null) {
            return;
        }
        WbSwingUtilities.invoke(() -> this.editor.appendLine(charSequence.toString()));
    }

    public void setScriptObjectName(String string) {
        this.mainObject = string;
    }

    private void startScripting() {
        if (this.isRunning()) {
            return;
        }
        if (!WbSwingUtilities.isConnectionIdle(this, this.scripter.getCurrentConnection())) {
            return;
        }
        WbThread wbThread = new WbThread("ObjectScripter Thread"){

            @Override
            public void run() {
                String string = ObjectScripterUI.this.window.getTitle();
                try {
                    ObjectScripterUI.this.setRunning(true);
                    ObjectScripterUI.this.window.setTitle("\u00bb " + string);
                    ObjectScripterUI.this.scripter.generateScript();
                }
                catch (Throwable throwable) {
                    ObjectScripterUI.this.window.setTitle(StringUtil.coalesce(ObjectScripterUI.this.mainObject, string));
                    ObjectScripterUI.this.setRunning(false);
                    EventQueue.invokeLater(() -> {
                        ObjectScripterUI.this.statusMessage.setText("");
                        ObjectScripterUI.this.editor.setCaretPosition(0);
                    });
                    throw throwable;
                }
                ObjectScripterUI.this.window.setTitle(StringUtil.coalesce(ObjectScripterUI.this.mainObject, string));
                ObjectScripterUI.this.setRunning(false);
                EventQueue.invokeLater(() -> {
                    ObjectScripterUI.this.statusMessage.setText("");
                    ObjectScripterUI.this.editor.setCaretPosition(0);
                });
            }
        };
        wbThread.start();
    }

    @Override
    public void setCurrentObject(String string, int n, int n2) {
        WbSwingUtilities.invoke(() -> {
            if (n > 0 && n2 > 0) {
                this.statusMessage.setText(string + " (" + n + "/" + n2 + ")");
            } else {
                this.statusMessage.setText(StringUtil.coalesce(string, ""));
            }
        });
    }

    public void show(Window window) {
        if (this.window == null) {
            this.window = new JFrame(ResourceMgr.getString("TxtWindowTitleGeneratedScript"));
            this.window.getContentPane().setLayout(new BorderLayout());
            this.window.getContentPane().add((Component)this, "Center");
            ResourceMgr.setWindowIcons((Window)this.window, "script");
            if (!Settings.getInstance().restoreWindowSize(this.window, ObjectScripterUI.class.getName())) {
                this.window.setSize(500, 400);
            }
            if (!Settings.getInstance().restoreWindowPosition(this.window, ObjectScripterUI.class.getName())) {
                WbSwingUtilities.center(this.window, window);
            }
            this.window.addWindowListener(this);
        }
        this.window.setVisible(true);
        this.startScripting();
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    private void cancel() {
        WbThread wbThread = new WbThread("Scripter Cancel"){

            @Override
            public void run() {
                try {
                    WbSwingUtilities.showWaitCursor(ObjectScripterUI.this.window);
                    ObjectScripterUI.this.statusMessage.setText(ResourceMgr.getString("MsgCancelling"));
                    Thread.yield();
                    ObjectScripterUI.this.scripter.cancel();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                finally {
                    WbSwingUtilities.showDefaultCursor(ObjectScripterUI.this.window);
                }
                ObjectScripterUI.this.scripter = null;
                ObjectScripterUI.this.setRunning(false);
                ObjectScripterUI.this.closeWindow();
            }
        };
        wbThread.start();
    }

    protected void closeWindow() {
        if (this.isRunning()) {
            return;
        }
        Settings.getInstance().storeWindowPosition(this.window, ObjectScripterUI.class.getName());
        Settings.getInstance().storeWindowSize(this.window, ObjectScripterUI.class.getName());
        this.window.setVisible(false);
        this.window.dispose();
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        if (this.isRunning()) {
            this.cancel();
            return;
        }
        this.closeWindow();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }
}

