/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.Frame;
import javax.swing.SwingWorker;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.dbobjects.ProgressDialog;
import workbench.interfaces.Interruptable;
import workbench.interfaces.ResultLogger;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.sql.BatchRunner;
import workbench.sql.ErrorDescriptor;
import workbench.sql.ErrorReportLevel;
import workbench.sql.ExecutionStatus;
import workbench.storage.RowActionMonitor;
import workbench.util.ExceptionUtil;

public class ScriptExecutionFeedback
extends SwingWorker<ExecutionStatus, String>
implements Interruptable {
    private WbConnection dbConn;
    private BatchRunner runner;
    private String sqlScript;
    private ResultLogger resultLogger;
    private ProgressDialog dialog;

    public ScriptExecutionFeedback(WbConnection wbConnection, String string, ResultLogger resultLogger) {
        this.dbConn = wbConnection;
        this.sqlScript = string;
        this.resultLogger = resultLogger;
    }

    public void runScript(String string, Frame frame) {
        this.dialog = new ProgressDialog(ResourceMgr.getString("TxtWindowTitleGeneratedScript"), frame, this, false);
        this.dialog.getInfoPanel().setCurrentObject(string, -1L, -1L);
        WbSwingUtilities.center(this.dialog, frame);
        this.execute();
        this.dialog.setVisible(true);
    }

    public ErrorDescriptor getLastError() {
        if (this.runner == null) {
            return null;
        }
        return this.runner.getLastError();
    }

    public int getLastErrorIndex() {
        if (this.runner == null) {
            return -1;
        }
        return this.runner.getLastErrorStatementIndex();
    }

    @Override
    public void cancelExecution() {
        if (this.runner != null) {
            this.runner.cancel();
        }
        this.cancel(true);
    }

    @Override
    public boolean confirmCancel() {
        return true;
    }

    @Override
    protected ExecutionStatus doInBackground() throws Exception {
        return this.startScript();
    }

    @Override
    protected void done() {
        super.done();
        if (this.dialog != null) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExecutionStatus startScript() {
        Object object;
        if (this.dbConn == null) {
            return ExecutionStatus.Error;
        }
        if (this.dbConn.isBusy()) {
            return ExecutionStatus.Error;
        }
        this.runner = new BatchRunner();
        if (this.dialog != null) {
            object = this.dialog.getMonitor();
            object.setMonitorType(7);
            this.runner.setRowMonitor((RowActionMonitor)object);
        }
        this.runner.setConnection(this.dbConn);
        this.runner.setAbortOnError(true);
        this.runner.setPrintStatements(false);
        this.runner.setShowProgress(false);
        this.runner.setShowTiming(false);
        this.runner.setStoreErrors(false);
        this.runner.setShowStatementWithResult(false);
        this.runner.setShowStatementSummary(false);
        this.runner.setErrorStatementLogging(ErrorReportLevel.none);
        this.runner.setAbortOnError(true);
        this.runner.setStoreErrors(true);
        this.runner.setMessageLogger(this.resultLogger);
        object = ExecutionStatus.Error;
        try {
            object = this.runner.runScript(this.sqlScript);
        }
        catch (Exception exception) {
            object = ExecutionStatus.Error;
            LogMgr.logError(new CallerInfo(){}, "Error when running script", exception);
            String string = ExceptionUtil.getDisplay(exception);
            this.resultLogger.appendToLog("\n" + string);
        }
        finally {
            this.runner.done();
        }
        return object;
    }
}

