/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import workbench.db.ColumnDropper;
import workbench.db.ColumnIdentifier;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.TableColumnsDatastore;
import workbench.db.TableDefinition;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.ColumnAlterAction;
import workbench.gui.actions.CreateDummySqlAction;
import workbench.gui.actions.CreateIndexAction;
import workbench.gui.actions.CreatePKAction;
import workbench.gui.actions.DeleteRowAction;
import workbench.gui.actions.DropDbObjectAction;
import workbench.gui.actions.DropPKAction;
import workbench.gui.actions.InsertRowAction;
import workbench.gui.actions.ReloadAction;
import workbench.gui.actions.WbAction;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.EmptyTableModel;
import workbench.gui.components.FlatButton;
import workbench.gui.components.QuickFilterPanel;
import workbench.gui.components.WbLabelField;
import workbench.gui.components.WbScrollPane;
import workbench.gui.components.WbTable;
import workbench.gui.components.WbTraversalPolicy;
import workbench.gui.dbobjects.ColumnChangeValidator;
import workbench.gui.dbobjects.DbObjectList;
import workbench.gui.renderer.RendererSetup;
import workbench.gui.renderer.SqlTypeRenderer;
import workbench.interfaces.DbData;
import workbench.interfaces.IndexChangeListener;
import workbench.interfaces.Reloadable;
import workbench.interfaces.Resettable;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.DbExplorerSettings;
import workbench.resource.GuiSettings;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.sql.wbcommands.ObjectInfo;
import workbench.storage.DataStore;
import workbench.util.ExceptionUtil;
import workbench.util.StringUtil;
import workbench.util.WbThread;

public class TableDefinitionPanel
extends JPanel
implements PropertyChangeListener,
ListSelectionListener,
Resettable,
DbObjectList,
IndexChangeListener {
    public static final String INDEX_PROP = "index";
    public static final String DEFINITION_PROP = "tableDefinition";
    private final ReentrantLock connectionLock = new ReentrantLock();
    private final Object busyLock = new Object();
    private WbTable tableDefinition;
    private WbLabelField tableNameLabel;
    private QuickFilterPanel columnFilter;
    private CreateIndexAction createIndexAction;
    private CreatePKAction createPKAction;
    private DropPKAction dropPKAction;
    private ColumnAlterAction alterColumnsAction;
    private TableIdentifier currentTable;
    private InsertRowAction addColumn;
    private DeleteRowAction deleteColumn;
    private WbConnection dbConnection;
    private WbAction reloadAction;
    private DropDbObjectAction dropColumnsAction;
    private JPanel toolbar;
    private boolean busy;
    private FlatButton alterButton;
    private ColumnChangeValidator validator = new ColumnChangeValidator();
    private boolean doRestore;
    private boolean initialized;

    private void initGui() {
        if (this.initialized) {
            return;
        }
        WbSwingUtilities.invoke(this::_initGui);
    }

    private void _initGui() {
        if (this.initialized) {
            return;
        }
        this.tableDefinition = new WbTable(true, false, false);
        this.tableDefinition.setAdjustToColumnLabel(false);
        this.tableDefinition.setSelectOnRightButtonClick(true);
        this.tableDefinition.getExportAction().setEnabled(true);
        this.tableDefinition.setRendererSetup(RendererSetup.getBaseSetup());
        this.updateReadOnlyState();
        Settings.getInstance().addPropertyChangeListener(this, "workbench.dbexplorer.allow.alter", new String[0]);
        this.reloadAction = new ReloadAction(this);
        this.reloadAction.setEnabled(false);
        this.reloadAction.addToInputMap(this.tableDefinition);
        this.toolbar = new JPanel(new GridBagLayout());
        this.alterColumnsAction = new ColumnAlterAction(this.tableDefinition);
        this.alterColumnsAction.setReloader(this);
        this.columnFilter = new QuickFilterPanel(this.tableDefinition, true, "columnlist");
        this.columnFilter.setColumnList(TableColumnsDatastore.TABLE_DEFINITION_COLS);
        this.columnFilter.setFilterOnType(DbExplorerSettings.getFilterDuringTyping());
        this.columnFilter.setAlwaysUseContainsFilter(DbExplorerSettings.getUsePartialMatch());
        DbData dbData = new DbData(){

            @Override
            public int addRow() {
                return TableDefinitionPanel.this.tableDefinition.addRow();
            }

            @Override
            public void deleteRow() {
                TableDefinitionPanel.this.tableDefinition.deleteRow();
            }

            @Override
            public void deleteRowWithDependencies() {
            }

            @Override
            public boolean startEdit() {
                return true;
            }

            @Override
            public int duplicateRow() {
                return -1;
            }

            @Override
            public void endEdit() {
            }
        };
        this.addColumn = new InsertRowAction(dbData);
        this.addColumn.initMenuDefinition("MnuTxtAddCol");
        this.deleteColumn = new DeleteRowAction(dbData);
        this.deleteColumn.initMenuDefinition("MnuTxtDropColumn");
        this.columnFilter.addToToolbar(this.addColumn, true, true);
        this.columnFilter.addToToolbar(this.deleteColumn, 1);
        this.columnFilter.addToToolbar(this.reloadAction, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.toolbar.add((Component)this.columnFilter, gridBagConstraints);
        JLabel jLabel = new JLabel(ResourceMgr.getString("LblTable") + ":");
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.toolbar.add((Component)jLabel, gridBagConstraints);
        this.tableNameLabel = new WbLabelField();
        this.tableNameLabel.useBoldFont();
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = WbSwingUtilities.getEmptyInsets();
        this.toolbar.add((Component)this.tableNameLabel, gridBagConstraints);
        gridBagConstraints.fill = 2;
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.alterButton = new FlatButton(this.alterColumnsAction);
        this.alterButton.showMessageOnEnable("MsgApplyDDLHint");
        this.alterButton.setIcon(null);
        this.alterButton.setUseDefaultMargin(false);
        this.toolbar.add((Component)this.alterButton, gridBagConstraints);
        WbScrollPane wbScrollPane = new WbScrollPane(this.tableDefinition);
        this.setLayout(new BorderLayout());
        this.add((Component)this.toolbar, "North");
        this.add((Component)wbScrollPane, "Center");
        this.createIndexAction = new CreateIndexAction(this, this);
        this.createPKAction = new CreatePKAction(this);
        this.dropPKAction = new DropPKAction(this);
        this.tableDefinition.addPopupAction(CreateDummySqlAction.createDummyInsertAction((DbObjectList)this, this.tableDefinition.getSelectionModel()), true);
        this.tableDefinition.addPopupAction(CreateDummySqlAction.createDummyUpdateAction((DbObjectList)this, this.tableDefinition.getSelectionModel()), false);
        this.tableDefinition.addPopupAction(CreateDummySqlAction.createDummySelectAction((DbObjectList)this, this.tableDefinition.getSelectionModel()), false);
        this.tableDefinition.getSelectionModel().addListSelectionListener(this);
        this.tableDefinition.addPopupAction(this.createPKAction, true);
        this.tableDefinition.addPopupAction(this.dropPKAction, false);
        this.tableDefinition.addPopupAction(this.createIndexAction, false);
        WbTraversalPolicy wbTraversalPolicy = new WbTraversalPolicy();
        wbTraversalPolicy.addComponent(this.tableDefinition);
        wbTraversalPolicy.setDefaultComponent(this.tableDefinition);
        this.setFocusCycleRoot(false);
        this.setFocusTraversalPolicy(wbTraversalPolicy);
        if (DbExplorerSettings.showFocusInDbExplorer()) {
            this.tableDefinition.showFocusBorder();
        }
        if (this.doRestore) {
            this.restoreSettings();
        }
        this.initialized = true;
    }

    protected void fireTableDefinitionChanged() {
        this.firePropertyChange(DEFINITION_PROP, null, this.currentTable.getTableName());
    }

    @Override
    public void indexChanged(TableIdentifier tableIdentifier, String string) {
        this.firePropertyChange(INDEX_PROP, null, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBusy() {
        Object object = this.busyLock;
        synchronized (object) {
            return this.busy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBusy(boolean bl) {
        Object object = this.busyLock;
        synchronized (object) {
            this.busy = bl;
        }
    }

    public void dispose() {
        if (this.tableDefinition != null) {
            this.tableDefinition.dispose();
        }
        if (this.columnFilter != null) {
            this.columnFilter.dispose();
        }
        WbAction.dispose(this.addColumn, this.deleteColumn, this.reloadAction, this.alterColumnsAction, this.createIndexAction, this.createPKAction, this.dropColumnsAction, this.dropPKAction);
        Settings.getInstance().removePropertyChangeListener(this);
        WbSwingUtilities.removeAllListeners(this);
    }

    public void retrieve(TableIdentifier tableIdentifier) throws SQLException {
        this.currentTable = tableIdentifier;
        this.initGui();
        this.retrieveTableDefinition();
    }

    protected void retrieveTableDefinition() throws SQLException {
        if (this.isBusy()) {
            return;
        }
        if (this.currentTable == null) {
            return;
        }
        if (!this.connectionLock.tryLock()) {
            LogMgr.logWarning(new CallerInfo(){}, "Concurrent table definition retrieval in process", new Exception("Backtrace"));
            this.reset();
            return;
        }
        try {
            TableModel tableModel;
            WbSwingUtilities.invoke(() -> {
                this.tableDefinition.reset();
                this.reloadAction.setEnabled(false);
                String string = " " + ResourceMgr.getString("TxtRetrieveTableDef") + " " + this.currentTable.getTableName();
                this.tableNameLabel.setText(string);
            });
            DbMetadata dbMetadata = this.dbConnection.getMetadata();
            DataStore dataStore = null;
            dataStore = this.dbConnection.getDbSettings().isSynonymType(this.currentTable.getType()) && !GuiSettings.showSynonymTargetInDbExplorer() ? ObjectInfo.getPlainSynonymInfo(this.dbConnection, this.currentTable) : dbMetadata.getObjectDetails(this.currentTable);
            TableModel tableModel2 = tableModel = dataStore == null ? EmptyTableModel.EMPTY_MODEL : new DataStoreTableModel(dataStore);
            if (dataStore instanceof TableColumnsDatastore) {
                DataStoreTableModel dataStoreTableModel = (DataStoreTableModel)tableModel;
                dataStoreTableModel.setValidator(this.validator);
                int n = dataStoreTableModel.findColumn("JDBC Type");
                int n2 = dataStoreTableModel.findColumn("POSITION");
                int n3 = dataStoreTableModel.findColumn("PK");
                dataStoreTableModel.setNonEditableColums(n, n2, n3);
                if (dbMetadata.isTableType(this.currentTable.getType()) || dbMetadata.isViewType(this.currentTable.getType())) {
                    List<ColumnIdentifier> list = TableColumnsDatastore.createColumnIdentifiers(dbMetadata, dataStore);
                    TableDefinition tableDefinition = new TableDefinition(this.currentTable, list);
                    this.dbConnection.getObjectCache().addTable(tableDefinition);
                }
            }
            this.alterButton.setVisible(this.dbConnection.getDbSettings().columnCommentAllowed(this.currentTable.getType()));
            WbSwingUtilities.invoke(() -> {
                this.applyTableModel(tableModel);
                this.tableDefinition.adjustColumns();
            });
            this.alterColumnsAction.setSourceTable(this.dbConnection, this.currentTable);
            this.alterColumnsAction.setEnabled(false);
            boolean bl = this.dbConnection.getDbSettings().getAddColumnSql() != null && DbExplorerSettings.allowAlterInDbExplorer();
            this.addColumn.setEnabled(bl && this.isTable());
        }
        catch (SQLException sQLException) {
            this.tableNameLabel.setText(ExceptionUtil.getDisplay(sQLException));
            throw sQLException;
        }
        finally {
            this.connectionLock.unlock();
            this.reloadAction.setEnabled(true);
            this.setBusy(false);
        }
    }

    protected void applyTableModel(TableModel tableModel) {
        String[] stringArray;
        Object object;
        Object object2;
        this.tableDefinition.setPrintHeader(this.currentTable.getTableName());
        this.tableDefinition.setAutoCreateColumnsFromModel(true);
        this.tableDefinition.setModel(tableModel, true);
        TableIdentifier tableIdentifier = this.currentTable;
        if (tableModel instanceof DataStoreTableModel && (object2 = ((DataStoreTableModel)tableModel).getDataStore()) instanceof TableColumnsDatastore && (object = ((TableColumnsDatastore)object2).getSourceTable()) != null) {
            tableIdentifier = object;
        }
        object2 = DbExplorerSettings.getDbExplorerTableDetailFullyQualified() ? tableIdentifier.getFullyQualifiedName(this.dbConnection) : tableIdentifier.getTableExpression(this.dbConnection);
        if (tableModel instanceof EmptyTableModel) {
            this.tableNameLabel.setText("");
        } else {
            this.tableNameLabel.setText((String)object2);
        }
        object = this.tableDefinition.getColumnModel();
        try {
            int n = object.getColumnIndex("JDBC Type");
            String[] stringArray2 = object.getColumn(n);
            stringArray2.setCellRenderer(new SqlTypeRenderer());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        for (String string : stringArray = new String[]{"SCALE/SIZE", "PRECISION"}) {
            try {
                int n = object.getColumnIndex(string);
                TableColumn tableColumn = object.getColumn(n);
                object.removeColumn(tableColumn);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    @Override
    public void reset() {
        if (!this.initialized) {
            return;
        }
        this.currentTable = null;
        this.tableDefinition.reset();
        this.reloadAction.setEnabled(false);
    }

    private DropDbObjectAction getDropColumnAction() {
        if (this.dropColumnsAction == null) {
            this.dropColumnsAction = new DropDbObjectAction("MnuTxtDropColumn", (DbObjectList)this, this.tableDefinition.getSelectionModel(), (Reloadable)this);
            this.dropColumnsAction.setDropper(new ColumnDropper());
        }
        return this.dropColumnsAction;
    }

    public void setConnection(WbConnection wbConnection) {
        this.initGui();
        this.dbConnection = wbConnection;
        this.createIndexAction.setConnection(this.dbConnection);
        this.reloadAction.setEnabled(this.dbConnection != null);
        this.validator.setConnection(this.dbConnection);
        if (this.dbConnection != null && this.dbConnection.getDbSettings().canDropType("column")) {
            DropDbObjectAction dropDbObjectAction = this.getDropColumnAction();
            dropDbObjectAction.setAvailable(true);
            this.tableDefinition.addPopupAction(dropDbObjectAction, false);
        } else if (this.dropColumnsAction != null) {
            this.dropColumnsAction.setAvailable(false);
        }
        this.addColumn.setEnabled(false);
    }

    @Override
    public void reload() {
        if (this.currentTable == null) {
            return;
        }
        if (this.dbConnection == null) {
            return;
        }
        this.initGui();
        WbThread wbThread = new WbThread("TableDefinition Retrieve"){

            @Override
            public void run() {
                try {
                    TableDefinitionPanel.this.retrieveTableDefinition();
                    TableDefinitionPanel.this.fireTableDefinitionChanged();
                }
                catch (SQLException sQLException) {
                    LogMgr.logError(new CallerInfo(){}, "Error loading table definition", sQLException);
                }
            }
        };
        wbThread.start();
    }

    @Override
    public List<TableIdentifier> getSelectedTables() {
        return Collections.emptyList();
    }

    @Override
    public List<DbObject> getSelectedObjects() {
        if (this.tableDefinition.getSelectedRowCount() <= 0) {
            return null;
        }
        int[] nArray = this.tableDefinition.getSelectedRows();
        ArrayList<DbObject> arrayList = new ArrayList<DbObject>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            String string = this.tableDefinition.getValueAsString(nArray[i], 0);
            if (!StringUtil.isNonBlank(string)) continue;
            arrayList.add(new ColumnIdentifier(string));
        }
        return arrayList;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public WbConnection getConnection() {
        return this.dbConnection;
    }

    @Override
    public TableIdentifier getObjectTable() {
        return this.currentTable;
    }

    @Override
    public int getSelectionCount() {
        return this.tableDefinition.getSelectedRowCount();
    }

    @Override
    public TableDefinition getCurrentTableDefinition() {
        return null;
    }

    protected boolean isTable() {
        if (this.currentTable == null) {
            return false;
        }
        if (this.dbConnection == null) {
            return false;
        }
        String string = this.currentTable.getType();
        return this.dbConnection.getMetadata().isExtendedTableType(string);
    }

    protected boolean isMview() {
        if (this.currentTable == null) {
            return false;
        }
        if (this.dbConnection == null) {
            return false;
        }
        String string = this.currentTable.getType();
        return this.dbConnection.getDbSettings().isMview(string);
    }

    protected boolean hasIndex() {
        if (this.currentTable == null) {
            return false;
        }
        if (this.dbConnection == null) {
            return false;
        }
        if (this.isTable()) {
            return true;
        }
        if (this.isMview()) {
            return true;
        }
        String string = this.currentTable.getType();
        return this.dbConnection.getMetadata().isViewType(string) && this.dbConnection.getDbSettings().supportsIndexedViews();
    }

    protected boolean hasPkColumn() {
        if (!this.isTable()) {
            return false;
        }
        for (int i = 0; i < this.tableDefinition.getRowCount(); ++i) {
            String string = this.tableDefinition.getValueAsString(i, 2);
            boolean bl = StringUtil.stringToBool(string);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!this.initialized) {
            return;
        }
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (listSelectionEvent.getSource() == this.tableDefinition.getSelectionModel()) {
            boolean bl = this.tableDefinition.getSelectedRowCount() > 0;
            boolean bl2 = this.isTable();
            boolean bl3 = this.isMview();
            boolean bl4 = this.hasPkColumn();
            this.createPKAction.setEnabled(bl && bl2 && !bl4);
            this.dropPKAction.setEnabled(bl2 && bl4);
            this.createIndexAction.setEnabled(bl && this.hasIndex());
            this.deleteColumn.setEnabled(bl && (bl2 || bl3) && DbExplorerSettings.allowAlterInDbExplorer());
        }
    }

    public List<ColumnIdentifier> getColumns() {
        return TableColumnsDatastore.createColumnIdentifiers(this.dbConnection.getMetadata(), this.tableDefinition.getDataStore());
    }

    public int getRowCount() {
        if (this.tableDefinition == null) {
            return 0;
        }
        return this.tableDefinition.getRowCount();
    }

    public DataStore getDataStore() {
        if (this.tableDefinition == null) {
            return null;
        }
        return this.tableDefinition.getDataStore();
    }

    public void restoreSettings() {
        if (this.columnFilter != null) {
            this.columnFilter.restoreSettings();
            this.doRestore = false;
        } else {
            this.doRestore = true;
        }
    }

    public void saveSettings() {
        if (this.columnFilter != null) {
            this.columnFilter.saveSettings();
            this.doRestore = false;
        } else {
            this.doRestore = true;
        }
    }

    private void updateReadOnlyState() {
        this.tableDefinition.setReadOnly(!DbExplorerSettings.allowAlterInDbExplorer());
        this.tableDefinition.setAllowEditMode(true);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("workbench.dbexplorer.allow.alter")) {
            this.updateReadOnlyState();
        }
    }
}

