/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataListener;
import workbench.db.TableIdentifier;
import workbench.resource.DbExplorerSettings;
import workbench.util.FixedSizeList;

public class TableHistoryModel
extends DefaultComboBoxModel {
    private final FixedSizeList<TableIdentifier> history = new FixedSizeList(DbExplorerSettings.getDbExplorerTableHistorySize());

    public TableIdentifier getSelectedTable() {
        return (TableIdentifier)this.getSelectedItem();
    }

    @Override
    public int getSize() {
        return this.history.size();
    }

    @Override
    public Object getElementAt(int n) {
        return this.history.get(n);
    }

    @Override
    public void addElement(Object object) {
        this.addTable((TableIdentifier)object);
    }

    public void addTable(TableIdentifier tableIdentifier) {
        this.insertElementAt(tableIdentifier, 0);
        this.fireIntervalAdded(this, 0, 0);
        this.setSelectedItem(tableIdentifier);
    }

    @Override
    public void removeElement(Object object) {
        int n = this.history.indexOf((TableIdentifier)object);
        if (n != -1) {
            this.removeElementAt(n);
        }
    }

    @Override
    public void insertElementAt(Object object, int n) {
        this.history.add(n, (TableIdentifier)object);
        this.fireIntervalAdded(this, n, n);
    }

    @Override
    public void removeElementAt(int n) {
        if (this.getElementAt(n) == this.getSelectedItem()) {
            if (n == 0) {
                this.setSelectedItem(this.getSize() == 1 ? null : this.getElementAt(n + 1));
            } else {
                this.setSelectedItem(this.getElementAt(n - 1));
            }
        }
        this.history.remove(n);
        this.fireIntervalRemoved(this, n, n);
    }

    @Override
    public void removeAllElements() {
        super.removeAllElements();
        int n = this.history.size();
        if (n > 0) {
            this.history.clear();
            this.fireIntervalRemoved(this, 0, n - 1);
        }
    }

    public void clearListeners() {
        List<EventListener> list = Arrays.asList(this.listenerList.getListeners(ListDataListener.class));
        for (ListDataListener listDataListener : list) {
            this.removeListDataListener(listDataListener);
        }
    }
}

