/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import workbench.db.TableIdentifier;
import workbench.db.WbConnection;
import workbench.db.vertica.VerticaProjectionReader;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.ReloadAction;
import workbench.gui.actions.WbAction;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.WbScrollPane;
import workbench.gui.components.WbSplitPane;
import workbench.gui.components.WbTabbedPane;
import workbench.gui.components.WbTable;
import workbench.gui.components.WbToolbar;
import workbench.gui.renderer.RendererSetup;
import workbench.gui.settings.PlacementChooser;
import workbench.interfaces.PropertyStorage;
import workbench.interfaces.Reloadable;
import workbench.interfaces.Resettable;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.FilteredProperties;
import workbench.util.WbThread;
import workbench.util.WbWorkspace;

public class VerticaProjectionPanel
extends JPanel
implements Resettable,
Reloadable,
ActionListener,
ListSelectionListener,
ChangeListener {
    protected WbTable projectionList;
    protected WbTable projectionBuddies;
    protected WbTable projectionColumns;
    private WbSplitPane splitPanel;
    private JTabbedPane displayTab;
    private ReloadAction reloadProjections;
    private boolean isRetrieving;
    private boolean isDetailsRetrieving;
    private boolean initialized;
    private TableIdentifier currentTable;
    private VerticaProjectionReader projectionReader = new VerticaProjectionReader();
    private FilteredProperties workspaceProperties;

    public VerticaProjectionPanel() {
        super(new BorderLayout());
    }

    private void initGui() {
        if (this.initialized) {
            return;
        }
        WbSwingUtilities.invoke(this::_initGui);
    }

    private void _initGui() {
        this.projectionList = new WbTable();
        this.projectionList.setAdjustToColumnLabel(false);
        this.projectionList.setRendererSetup(RendererSetup.getBaseSetup());
        this.projectionList.getSelectionModel().addListSelectionListener(this);
        this.projectionList.getSelectionModel().setSelectionMode(0);
        WbScrollPane wbScrollPane = new WbScrollPane(this.projectionList);
        this.projectionBuddies = new WbTable();
        this.projectionBuddies.setAdjustToColumnLabel(false);
        this.projectionBuddies.setRendererSetup(RendererSetup.getBaseSetup());
        this.projectionBuddies.getSelectionModel().addListSelectionListener(this);
        this.projectionBuddies.getSelectionModel().setSelectionMode(0);
        WbScrollPane wbScrollPane2 = new WbScrollPane(this.projectionBuddies);
        this.projectionColumns = new WbTable();
        this.projectionColumns.setAdjustToColumnLabel(false);
        this.projectionColumns.setRendererSetup(RendererSetup.getBaseSetup());
        WbScrollPane wbScrollPane3 = new WbScrollPane(this.projectionColumns);
        int n = PlacementChooser.getPlacementLocation();
        this.displayTab = new WbTabbedPane(n);
        this.displayTab.setBorder(WbSwingUtilities.EMPTY_BORDER);
        this.displayTab.setName("displaytab");
        this.displayTab.add("Buddies", wbScrollPane2);
        this.displayTab.add(ResourceMgr.getString("TxtDbExplorerTableDefinition"), wbScrollPane3);
        this.displayTab.addChangeListener(this);
        this.splitPanel = new WbSplitPane(0);
        this.splitPanel.setDividerSize(8);
        this.splitPanel.setTopComponent(wbScrollPane);
        this.splitPanel.setBottomComponent(this.displayTab);
        WbToolbar wbToolbar = new WbToolbar();
        wbToolbar.setBorder(new EtchedBorder(1));
        this.reloadProjections = new ReloadAction(this);
        wbToolbar.add(this.reloadProjections);
        wbToolbar.addSeparator();
        this.add((Component)wbToolbar, "North");
        this.add((Component)this.splitPanel, "Center");
        this.splitPanel.setDividerLocation(0.5);
        this.initialized = true;
        this.restoreSettings();
        if (this.workspaceProperties != null) {
            this.readSettings(this.workspaceProperties, this.workspaceProperties.getFilterPrefix());
            this.workspaceProperties = null;
        }
    }

    public void setConnection(WbConnection wbConnection) {
        this.reset();
        this.projectionReader.setConnection(wbConnection);
    }

    @Override
    public void reset() {
        if (this.initialized) {
            this.projectionList.reset();
            this.projectionBuddies.reset();
            this.projectionColumns.reset();
        }
    }

    public boolean isRetrieving() {
        return this.isRetrieving || this.isDetailsRetrieving;
    }

    public void reloadTable() {
        try {
            this.reset();
            this.retrieve(this.currentTable);
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not reload projections", sQLException);
        }
    }

    protected void retrieve(TableIdentifier tableIdentifier) throws SQLException {
        this.initGui();
        try {
            this.currentTable = tableIdentifier;
            this.isRetrieving = true;
            DataStoreTableModel dataStoreTableModel = new DataStoreTableModel(this.getProjectionDataStore(tableIdentifier));
            WbSwingUtilities.invoke(() -> {
                this.projectionList.setModel(dataStoreTableModel, true);
                this.projectionList.adjustRowsAndColumns();
                this.projectionBuddies.reset();
                this.projectionColumns.reset();
            });
        }
        finally {
            this.isRetrieving = false;
        }
    }

    private DataStore getProjectionDataStore(TableIdentifier tableIdentifier) throws SQLException {
        return this.projectionReader.getProjectionList(tableIdentifier);
    }

    private DataStore getProjectionCopiesDataStore(String string, String string2) throws SQLException {
        return this.projectionReader.getProjectionCopies(string, string2);
    }

    private DataStore getProjectionColumnsDataStore(String string, String string2) throws SQLException {
        return this.projectionReader.getProjectionColumns(string, string2);
    }

    public void dispose() {
        this.reset();
        WbAction.dispose(this.reloadProjections);
    }

    protected void retrieveProjectionCopies() {
        try {
            int n = Math.max(0, this.projectionList.getSelectedRow());
            String string = this.projectionList.getValueAsString(n, 0);
            String string2 = this.currentTable.getSchema();
            DataStoreTableModel dataStoreTableModel = new DataStoreTableModel(this.getProjectionCopiesDataStore(string, string2));
            WbSwingUtilities.invoke(() -> {
                this.projectionBuddies.setModel(dataStoreTableModel, true);
                this.projectionBuddies.adjustRowsAndColumns();
            });
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve projection copies", sQLException);
        }
    }

    protected void retrieveProjectionColumns() {
        try {
            int n = Math.max(0, this.projectionList.getSelectedRow());
            String string = this.projectionList.getValueAsString(n, 0);
            String string2 = this.currentTable.getSchema();
            DataStoreTableModel dataStoreTableModel = new DataStoreTableModel(this.getProjectionColumnsDataStore(string, string2));
            WbSwingUtilities.invoke(() -> {
                this.projectionColumns.setModel(dataStoreTableModel, true);
                this.projectionColumns.adjustRowsAndColumns();
            });
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not retrieve projection columns", sQLException);
        }
    }

    protected void retrieveCurrentPanel() {
        if (this.projectionList.getSelectedRowCount() < 1) {
            return;
        }
        switch (this.displayTab.getSelectedIndex()) {
            case 0: {
                if (this.projectionBuddies.getRowCount() >= 1) break;
                this.retrieveProjectionCopies();
                break;
            }
            case 1: {
                if (this.projectionColumns.getRowCount() >= 1) break;
                this.retrieveProjectionColumns();
            }
        }
    }

    @Override
    public void reload() {
        this.reloadTable();
    }

    public void reloadDetails() {
        WbThread wbThread = new WbThread("ProjectionDetailsRetriever"){

            @Override
            public void run() {
                try {
                    VerticaProjectionPanel.this.isDetailsRetrieving = true;
                    VerticaProjectionPanel.this.retrieveCurrentPanel();
                }
                finally {
                    VerticaProjectionPanel.this.isDetailsRetrieving = false;
                    VerticaProjectionPanel.this.reloadProjections.setEnabled(true);
                    WbSwingUtilities.showDefaultCursor(VerticaProjectionPanel.this);
                }
            }
        };
        this.reloadProjections.setEnabled(false);
        WbSwingUtilities.showWaitCursor(this);
        wbThread.start();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.initialized) {
            return;
        }
        if (actionEvent.getSource() != this.reloadProjections) {
            return;
        }
        LogMgr.logDebug(new CallerInfo(){}, "Trying to select projection copies");
        WbSwingUtilities.invokeLater(this::reload);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!this.initialized) {
            return;
        }
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (listSelectionEvent.getSource() == this.projectionList.getSelectionModel()) {
            this.projectionBuddies.reset();
            this.projectionColumns.reset();
            LogMgr.logDebug(new CallerInfo(){}, "Trying to select projection copies");
            WbSwingUtilities.invokeLater(this::reloadDetails);
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (!this.initialized) {
            return;
        }
        if (changeEvent.getSource() == this.displayTab) {
            EventQueue.invokeLater(this::reloadDetails);
        }
    }

    private String getWorkspacePrefix(int n) {
        return "dbexplorer" + n + ".projections.";
    }

    public void saveSettings() {
        if (this.initialized) {
            this.storeSettings(Settings.getInstance(), this.getClass().getName() + ".");
        }
    }

    public void saveToWorkspace(WbWorkspace wbWorkspace, int n) {
        String string = this.getWorkspacePrefix(n);
        if (this.initialized) {
            this.storeSettings(wbWorkspace.getSettings(), string);
        } else if (this.workspaceProperties != null) {
            this.workspaceProperties.copyTo(wbWorkspace.getSettings(), string);
        }
    }

    private void storeSettings(PropertyStorage propertyStorage, String string) {
        propertyStorage.setProperty(string + "divider", this.splitPanel.getDividerLocation());
    }

    public void restoreSettings() {
        if (this.initialized) {
            this.readSettings(Settings.getInstance(), this.getClass().getName() + ".");
        }
    }

    public void readFromWorkspace(WbWorkspace wbWorkspace, int n) {
        String string = this.getWorkspacePrefix(n);
        if (this.initialized) {
            this.readSettings(wbWorkspace.getSettings(), string);
        } else {
            this.workspaceProperties = new FilteredProperties(wbWorkspace.getSettings(), string);
        }
    }

    private void readSettings(PropertyStorage propertyStorage, String string) {
        if (this.initialized) {
            int n = propertyStorage.getIntProperty(string + "divider", 200);
            this.splitPanel.setDividerLocation(n);
        }
    }
}

