/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects.objecttree;

import java.sql.SQLException;
import workbench.db.DbMetadata;
import workbench.db.DbObject;
import workbench.db.DbSettings;
import workbench.db.WbConnection;
import workbench.gui.dbobjects.objecttree.ObjectTreeNode;
import workbench.gui.dbobjects.objecttree.TreeLoader;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.storage.DataStore;

public class CatalogObjectNode
extends ObjectTreeNode {
    private final String catalog;

    public CatalogObjectNode(String string, String string2) {
        super(string2, "dbobject-type");
        this.catalog = string;
        this.setAllowsChildren(true);
    }

    @Override
    public boolean loadChildren(WbConnection wbConnection, TreeLoader treeLoader) {
        if (wbConnection == null) {
            return false;
        }
        DbSettings dbSettings = wbConnection.getDbSettings();
        if (dbSettings == null) {
            return false;
        }
        DbMetadata dbMetadata = wbConnection.getMetadata();
        if (dbMetadata == null) {
            return false;
        }
        try {
            DataStore dataStore = dbMetadata.getObjects(this.catalog, null, new String[]{this.getName()});
            for (int i = 0; i < dataStore.getRowCount(); ++i) {
                DbObject dbObject = (DbObject)dataStore.getRow(i).getUserObject();
                if (dbObject == null) continue;
                ObjectTreeNode objectTreeNode = new ObjectTreeNode(dbObject);
                this.add(objectTreeNode);
            }
        }
        catch (SQLException sQLException) {
            LogMgr.logError(new CallerInfo(){}, "Could not load catalog type: " + this.getName(), sQLException);
        }
        this.setChildrenLoaded(true);
        return true;
    }
}

