/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects.objecttree;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import workbench.db.ColumnIdentifier;
import workbench.db.DbObject;
import workbench.db.ProcedureDefinition;
import workbench.gui.dbobjects.objecttree.ObjectTreeNode;
import workbench.resource.IconMgr;
import workbench.util.CaseInsensitiveComparator;
import workbench.util.CollectionUtil;

public class DbObjectNodeRenderer
extends DefaultTreeCellRenderer {
    private Map<String, String> iconMap = new TreeMap<String, String>(CaseInsensitiveComparator.INSTANCE);
    private Map<String, String> iconMapOpen = new TreeMap<String, String>(CaseInsensitiveComparator.INSTANCE);
    private List<String> tableTypes = new ArrayList<String>();
    private List<String> viewTypes = new ArrayList<String>();

    public DbObjectNodeRenderer() {
        this.iconMap.put("table", "table");
        this.iconMap.put("system table", "table");
        this.iconMap.put("view", "view");
        this.iconMap.put("system view", "view");
        this.iconMap.put("SYNONYM", "synonym");
        this.iconMap.put("sequence", "sequence");
        this.iconMap.put("MATERIALIZED VIEW", "mview");
        this.iconMap.put("database", "profile");
        this.iconMap.put("schema", "folder");
        this.iconMap.put("global", "global");
        this.iconMap.put("catalog", "folder-db");
        this.iconMap.put("dbobject-type", "db_type");
        this.iconMap.put("procedures", "db_type");
        this.iconMap.put("table-trigger", "db_type");
        this.iconMap.put("dep-used", "deps-used");
        this.iconMap.put("dep-using", "deps-using");
        this.iconMap.put("column-list", "folder");
        this.iconMap.put("index-list", "folder");
        this.iconMap.put("referencing-fk-list", "folder");
        this.iconMap.put("referenced-fk-list", "folder");
        this.iconMap.put("table-partitions-node", "partitions");
        this.iconMap.put("procedure", "sproc");
        this.iconMap.put("trigger", "bullet_black");
        this.iconMap.put("index", "index");
        this.iconMap.put("type", "type");
        this.iconMap.put("foreign server", "server");
        this.iconMap.put("package", "package");
        this.iconMap.put("SUBSCRIPTION", "subscription");
        this.iconMap.put("PUBLICATION", "publication");
        this.iconMapOpen.put("schema", "folder-open");
        this.iconMapOpen.put("catalog", "folder-open-db");
        this.iconMapOpen.put("column-list", "folder-open");
        this.iconMapOpen.put("index-list", "folder-open");
        this.iconMapOpen.put("referencing-fk-list", "folder-open");
        this.iconMapOpen.put("referenced-fk-list", "folder-open");
        this.setLeafIcon(IconMgr.getInstance().getLabelIcon("bullet_black"));
    }

    public void setViewTypes(Collection<String> collection) {
        if (CollectionUtil.isEmpty(collection)) {
            return;
        }
        for (String string : this.viewTypes) {
            this.iconMap.remove(string);
        }
        this.viewTypes = new ArrayList<String>(collection);
        for (String string : collection) {
            this.iconMap.put(string, "view");
        }
        this.iconMap.put("view", "view");
        this.iconMap.put("MATERIALIZED VIEW", "mview");
    }

    public void setTableTypes(List<String> list) {
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        for (String string : this.tableTypes) {
            this.iconMap.remove(string);
        }
        this.tableTypes = new ArrayList<String>(list);
        for (String string : list) {
            this.iconMap.put(string, "table");
        }
        this.iconMap.put("table", "table");
        this.iconMap.put("MATERIALIZED VIEW", "mview");
    }

    public void setSynonymTypeName(String string) {
        this.iconMap.put(string, "synonym");
    }

    @Override
    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        if (object instanceof ObjectTreeNode) {
            ObjectTreeNode objectTreeNode = (ObjectTreeNode)object;
            String string = objectTreeNode.getType();
            DbObject dbObject = objectTreeNode.getDbObject();
            if (dbObject instanceof ColumnIdentifier) {
                ColumnIdentifier columnIdentifier = (ColumnIdentifier)dbObject;
                if (columnIdentifier.isPkColumn()) {
                    this.setIcon(IconMgr.getInstance().getLabelIcon("key"));
                } else {
                    this.setIcon(IconMgr.getInstance().getLabelIcon("bullet_black"));
                }
            } else if (dbObject instanceof ProcedureDefinition) {
                ProcedureDefinition procedureDefinition = (ProcedureDefinition)dbObject;
                if (procedureDefinition.isFunction()) {
                    this.setIcon(IconMgr.getInstance().getLabelIcon("sfunc"));
                } else {
                    this.setIcon(IconMgr.getInstance().getLabelIcon("sproc"));
                }
            } else {
                String string2 = null;
                if (bl2 && (string2 = objectTreeNode.getIconKeyOpen()) == null) {
                    string2 = this.iconMapOpen.get(string);
                }
                if (string2 == null && (string2 = objectTreeNode.getIconKey()) == null) {
                    string2 = this.iconMap.get(string);
                }
                if (string2 != null) {
                    this.setIcon(IconMgr.getInstance().getLabelIcon(string2));
                }
            }
            this.setToolTipText(objectTreeNode.getTooltip());
        }
        return component;
    }
}

