/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects.objecttree;

import java.util.Comparator;
import java.util.List;
import workbench.db.DbObject;
import workbench.util.SqlUtil;
import workbench.util.StringUtil;

public class DbObjectSorter
implements Comparator<DbObject> {
    private boolean includeType;
    private boolean useNaturalSort;

    public DbObjectSorter(boolean bl) {
        this.useNaturalSort = bl;
    }

    public void setIncludeType(boolean bl) {
        this.includeType = bl;
    }

    public void setUseNaturalSort(boolean bl) {
        this.useNaturalSort = bl;
    }

    @Override
    public int compare(DbObject dbObject, DbObject dbObject2) {
        String string;
        String string2;
        int n;
        if (dbObject == null && dbObject2 != null) {
            return 1;
        }
        if (dbObject != null && dbObject2 == null) {
            return -1;
        }
        if (dbObject == null && dbObject2 == null) {
            return 0;
        }
        if (this.includeType && (n = StringUtil.compareStrings(string2 = dbObject.getObjectType(), string = dbObject2.getObjectType(), true)) != 0) {
            return n;
        }
        string2 = SqlUtil.removeObjectQuotes(dbObject.getObjectName());
        string = SqlUtil.removeObjectQuotes(dbObject2.getObjectName());
        if (this.useNaturalSort) {
            return StringUtil.naturalCompare(string2, string, true);
        }
        return StringUtil.compareStrings(string2, string, true);
    }

    public static void sort(List<? extends DbObject> list, boolean bl) {
        DbObjectSorter.sort(list, bl, false);
    }

    public static void sort(List<? extends DbObject> list, boolean bl, boolean bl2) {
        if (list == null) {
            return;
        }
        DbObjectSorter dbObjectSorter = new DbObjectSorter(bl);
        dbObjectSorter.setIncludeType(bl2);
        list.sort(dbObjectSorter);
    }
}

