/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects.objecttree;

import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.io.Serializable;
import javax.swing.tree.TreePath;
import workbench.gui.dbobjects.objecttree.DbObjectsTree;
import workbench.gui.dbobjects.objecttree.ObjectTreeNode;
import workbench.gui.dbobjects.objecttree.ObjectTreeTransferable;

public class ObjectTreeDragSource
implements DragSourceListener,
DragGestureListener,
Serializable {
    private DragSource source;
    private ObjectTreeTransferable transferable;
    private DbObjectsTree sourceTree;

    public ObjectTreeDragSource(DbObjectsTree dbObjectsTree) {
        this.sourceTree = dbObjectsTree;
        this.source = new DragSource();
        this.source.createDefaultDragGestureRecognizer(this.sourceTree, 1, this);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        TreePath[] treePathArray = this.sourceTree.getSelectionPaths();
        if (treePathArray == null) {
            return;
        }
        ObjectTreeNode[] objectTreeNodeArray = new ObjectTreeNode[treePathArray.length];
        for (int i = 0; i < treePathArray.length; ++i) {
            objectTreeNodeArray[i] = (ObjectTreeNode)treePathArray[i].getLastPathComponent();
        }
        this.transferable = new ObjectTreeTransferable(objectTreeNodeArray, this.sourceTree.getConnection().getId());
        this.source.startDrag(dragGestureEvent, DragSource.DefaultCopyDrop, this.transferable, this);
    }

    @Override
    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }
}

