/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dbobjects.objecttree.vertica;

import workbench.db.WbConnection;
import workbench.db.vertica.VerticaProjectionReader;
import workbench.gui.dbobjects.objecttree.ObjectTreeNode;
import workbench.gui.dbobjects.objecttree.TreeLoader;
import workbench.gui.dbobjects.objecttree.vertica.ProjectionColumn;
import workbench.gui.dbobjects.objecttree.vertica.ProjectionNode;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.storage.DataStore;

public class ProjectionColumnsNode
extends ObjectTreeNode {
    public ProjectionColumnsNode() {
        super(ResourceMgr.getString("TxtDbExplorerTableDefinition"), "projection-columns");
        this.setAllowsChildren(true);
    }

    @Override
    public boolean loadChildren(WbConnection wbConnection, TreeLoader treeLoader) {
        if (this.getParent() == null) {
            return false;
        }
        ProjectionNode projectionNode = (ProjectionNode)this.getParent();
        this.loadProjectionColumns(wbConnection, projectionNode);
        return true;
    }

    private void loadProjectionColumns(WbConnection wbConnection, ProjectionNode projectionNode) {
        VerticaProjectionReader verticaProjectionReader = new VerticaProjectionReader();
        verticaProjectionReader.setConnection(wbConnection);
        try {
            DataStore dataStore = verticaProjectionReader.getProjectionColumns(projectionNode.getName(), projectionNode.getBaseTable().getSchema());
            for (int i = 0; i < dataStore.getRowCount(); ++i) {
                String string = dataStore.getValueAsString(i, "projection_column_name");
                String string2 = dataStore.getValueAsString(i, "data_type");
                this.add(new ProjectionColumn(string, string2));
            }
            this.setChildrenLoaded(true);
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Could not load projection columns", exception);
        }
    }
}

