/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.sql.Blob;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.EscAction;
import workbench.gui.dialogs.ImagePanel;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;

public class ImageViewer
extends JDialog
implements ActionListener,
WindowListener {
    private ImagePanel panel;
    private JButton closeButton = new JButton(ResourceMgr.getString("LblClose"));
    private final String settingsId = "workbench.gui.imageviewer";

    public ImageViewer(Frame frame, String string) {
        super(frame, string, true);
        this.init();
        WbSwingUtilities.center(this, frame);
    }

    public ImageViewer(Dialog dialog, String string) {
        super(dialog, string, true);
        this.init();
        WbSwingUtilities.center(this, dialog.getParent());
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout());
        this.setDefaultCloseOperation(2);
        this.panel = new ImagePanel();
        this.getContentPane().add((Component)this.panel, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 10, 10));
        jPanel.add(this.closeButton);
        this.closeButton.addActionListener(this);
        this.getContentPane().add((Component)jPanel, "South");
        this.addWindowListener(this);
        if (!Settings.getInstance().restoreWindowSize(this, "workbench.gui.imageviewer")) {
            this.setSize(640, 480);
        }
        this.getRootPane().setDefaultButton(this.closeButton);
        new EscAction(this, this);
    }

    public void setData(Object object) {
        try {
            if (object instanceof Blob) {
                this.panel.setImage((Blob)object);
            } else if (object instanceof byte[]) {
                this.panel.setImage((byte[])object);
            } else if (object instanceof File) {
                this.panel.setImage((File)object);
            }
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error reading image", exception);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        Settings.getInstance().storeWindowSize(this, "workbench.gui.imageviewer");
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

