/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.dialogs.export;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import workbench.db.ColumnIdentifier;
import workbench.db.WbConnection;
import workbench.db.exporter.DataExporter;
import workbench.db.exporter.ExportType;
import workbench.gui.MainWindow;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.FeedbackWindow;
import workbench.gui.components.ValidatingDialog;
import workbench.gui.dialogs.export.ExportOptions;
import workbench.gui.dialogs.export.ExportOptionsPanel;
import workbench.gui.dialogs.export.HtmlOptions;
import workbench.gui.dialogs.export.SpreadSheetOptions;
import workbench.gui.dialogs.export.SqlOptions;
import workbench.gui.dialogs.export.TextOptions;
import workbench.gui.dialogs.export.XmlOptions;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.storage.ResultInfo;
import workbench.util.ExceptionUtil;
import workbench.util.WbFile;
import workbench.util.WbThread;

public class ExportFileDialog
implements PropertyChangeListener {
    private ExportType exportType = null;
    private String selectedFilename = null;
    private boolean isCancelled = false;
    private ExportOptionsPanel exportOptions;
    private boolean selectDirectory = false;
    private boolean includeSqlUpdate = true;
    private boolean includeSqlInsert = true;
    private String lastDirConfigKey = "workbench.export.lastdir";
    private static final String SIZE_KEY = "workbench.saveas.dialog";
    private final DataStore source;
    private boolean sqlChecked = false;
    private Component parentComponent;
    private FeedbackWindow checkWindow;

    public ExportFileDialog(Component component) {
        this.source = null;
        this.exportOptions = new ExportOptionsPanel(null);
        this.parentComponent = component;
    }

    public ExportFileDialog(Component component, DataStore dataStore) {
        this.source = dataStore;
        this.exportOptions = new ExportOptionsPanel(this.source == null ? null : this.source.getResultInfo());
        this.parentComponent = component;
    }

    public ExportFileDialog(Component component, ResultInfo resultInfo) {
        this.source = null;
        this.exportOptions = new ExportOptionsPanel(resultInfo);
        this.parentComponent = component;
    }

    public void setQuerySql(String string, WbConnection wbConnection) {
        this.exportOptions.setQuerySql(string, wbConnection);
    }

    public List<ColumnIdentifier> getColumnsToExport() {
        return this.exportOptions.getColumnsToExport();
    }

    public void saveSettings() {
        this.exportOptions.saveSettings();
    }

    public void restoreSettings() {
        this.exportOptions.restoreSettings();
    }

    public SpreadSheetOptions getOdsOptions() {
        return this.exportOptions.getOdsOptions();
    }

    public SpreadSheetOptions getXlsOptions() {
        return this.exportOptions.getXlsOptions();
    }

    public SpreadSheetOptions getXlsXOptions() {
        return this.exportOptions.getXlsXOptions();
    }

    public SpreadSheetOptions getXlsMOptions() {
        return this.exportOptions.getXlsMOptions();
    }

    public SqlOptions getSqlOptions() {
        return this.exportOptions.getSqlOptions();
    }

    public HtmlOptions getHtmlOptions() {
        return this.exportOptions.getHtmlOptions();
    }

    public TextOptions getTextOptions() {
        return this.exportOptions.getTextOptions();
    }

    public XmlOptions getXmlOptions() {
        return this.exportOptions.getXmlOptions();
    }

    public ExportOptions getBasicExportOptions() {
        return this.exportOptions.getExportOptions();
    }

    public String getSelectedFilename() {
        return this.selectedFilename;
    }

    public ExportType getExportType() {
        return this.exportType;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setIncludeSqlUpdate(boolean bl) {
        this.includeSqlUpdate = bl;
    }

    public void setIncludeSqlInsert(boolean bl) {
        this.includeSqlInsert = bl;
    }

    public void setConfigKey(String string) {
        this.lastDirConfigKey = string;
    }

    public void setSelectDirectoryOnly(boolean bl) {
        this.selectDirectory = bl;
    }

    public boolean doOpenFile() {
        return this.exportOptions.doOpenFile();
    }

    public void openOutputFile() {
        File file = this.exportOptions.getSelectedFile();
        ExportFileDialog.openFile(file);
    }

    public static void openFile(final File file) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        WbThread wbThread = new WbThread("OpenFile - " + file.getName()){

            @Override
            public void run() {
                try {
                    Desktop.getDesktop().open(file);
                }
                catch (Exception exception) {
                    LogMgr.logError(new CallerInfo(){}, "Error when opening file", exception);
                    WbSwingUtilities.showErrorMessage(ExceptionUtil.getDisplay(exception));
                }
            }
        };
        wbThread.start();
    }

    public void setAllowOpenFile(boolean bl) {
        this.exportOptions.setAllowOpenFile(bl);
    }

    public void setExportInfo(String string) {
        this.exportOptions.setExportInfo(string);
    }

    public boolean selectOutput() {
        return this.selectOutput(ResourceMgr.getString("TxtWindowTitleSaveData"));
    }

    public boolean selectOutput(String string) {
        this.exportType = null;
        this.selectedFilename = null;
        boolean bl = false;
        MainWindow mainWindow = WbSwingUtilities.getMainWindow(this.parentComponent);
        this.exportOptions.setLastDirProperty(this.lastDirConfigKey);
        this.exportOptions.setSelectDirectoriesOnly(this.selectDirectory);
        int n = IconMgr.getInstance().getSizeForLabel() / 3;
        this.exportOptions.setBorder(new EmptyBorder(n, n, n, n));
        ValidatingDialog validatingDialog = new ValidatingDialog((Frame)mainWindow, string, (JComponent)this.exportOptions);
        if (!Settings.getInstance().restoreWindowSize(validatingDialog, SIZE_KEY)) {
            this.exportOptions.setExportType(ExportType.SQL_INSERT);
            validatingDialog.pack();
            validatingDialog.setSize(640, (int)((double)validatingDialog.getHeight() * 1.05));
        }
        validatingDialog.setDefaultButton(0);
        WbSwingUtilities.center(validatingDialog, mainWindow);
        this.restoreSettings();
        this.exportOptions.addPropertyChangeListener("exportType", this);
        if (this.exportOptions.getExportType().isSqlType()) {
            EventQueue.invokeLater(this::checkSqlOptions);
        }
        validatingDialog.setVisible(true);
        boolean bl2 = !validatingDialog.isCancelled();
        Settings.getInstance().storeWindowSize(validatingDialog, SIZE_KEY);
        if (bl2) {
            this.isCancelled = false;
            this.exportType = this.exportOptions.getExportType();
            WbFile wbFile = new WbFile(this.exportOptions.getSelectedFile());
            this.saveSettings();
            this.selectedFilename = wbFile.getFullPath();
            bl = true;
        } else {
            this.isCancelled = true;
            bl = false;
        }
        return bl;
    }

    public void setExporterOptions(DataExporter dataExporter) {
        dataExporter.setOptions(this.getBasicExportOptions());
        switch (this.exportType) {
            case SQL_INSERT: 
            case SQL_UPDATE: 
            case SQL_DELETE_INSERT: 
            case SQL_DELETE: {
                dataExporter.setSqlOptions(this.getSqlOptions());
                break;
            }
            case TEXT: {
                dataExporter.setTextOptions(this.getTextOptions());
                break;
            }
            case HTML: {
                dataExporter.setHtmlOptions(this.getHtmlOptions());
                break;
            }
            case XML: {
                dataExporter.setXmlOptions(this.getXmlOptions());
                break;
            }
            case ODS: {
                dataExporter.setOdsOptions(this.getOdsOptions());
                break;
            }
            case XLSX: {
                dataExporter.setXlsXOptions(this.getXlsXOptions());
                break;
            }
            case XLSM: {
                dataExporter.setXlsMOptions(this.getXlsMOptions());
                break;
            }
            case XLS: {
                dataExporter.setXlsOptions(this.getXlsOptions());
                break;
            }
            case JSON: {
                dataExporter.setOutputType(ExportType.JSON);
                break;
            }
            default: {
                dataExporter.setTextOptions(this.getTextOptions());
                LogMgr.logWarning(new CallerInfo(){}, "Unknown file type selected", null);
            }
        }
    }

    protected void checkSqlOptions() {
        if (this.sqlChecked) {
            return;
        }
        if (this.source == null) {
            return;
        }
        if (this.source.hasPkColumns()) {
            return;
        }
        if (this.checkWindow != null) {
            return;
        }
        Dialog dialog = (Dialog)SwingUtilities.getWindowAncestor(this.exportOptions);
        this.checkWindow = new FeedbackWindow(dialog, ResourceMgr.getString("MsgRetrievingKeyColumns"));
        WbSwingUtilities.center(this.checkWindow, dialog);
        WbSwingUtilities.showWaitCursor(this.exportOptions);
        this.checkWindow.showAndStart(this::_checkSqlOptions);
    }

    private void updateSqlFlags() {
        this.exportOptions.updateSqlOptions(this.source);
        this.includeSqlInsert = this.source != null && this.source.canSaveAsSqlInsert();
        this.includeSqlUpdate = this.source != null && this.source.hasPkColumns();
    }

    protected void _checkSqlOptions() {
        if (this.source == null) {
            return;
        }
        try {
            this.sqlChecked = true;
            this.source.updatePkInformation();
            this.updateSqlFlags();
        }
        catch (Exception exception) {
            LogMgr.logError(new CallerInfo(){}, "Error checking SQL Options", exception);
            WbSwingUtilities.showErrorMessage(ExceptionUtil.getDisplay(exception));
        }
        finally {
            WbSwingUtilities.showDefaultCursor(this.exportOptions);
            if (this.checkWindow != null) {
                this.checkWindow.setVisible(false);
                this.checkWindow.dispose();
                this.checkWindow = null;
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.exportOptions == null) {
            return;
        }
        if (propertyChangeEvent.getSource() == this.exportOptions) {
            try {
                ExportType exportType = (ExportType)((Object)propertyChangeEvent.getNewValue());
                switch (exportType) {
                    case SQL_INSERT: 
                    case SQL_UPDATE: 
                    case SQL_DELETE_INSERT: {
                        this.checkSqlOptions();
                    }
                }
            }
            catch (Throwable throwable) {
                LogMgr.logWarning(new CallerInfo(){}, "Could check SQL options");
            }
        }
    }
}

