/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor;

import workbench.util.StringUtil;

public class ClipboardCleaner {
    private final String toReplace;
    private final String replacements;

    public ClipboardCleaner() {
        int n;
        String string = "\u2012\u2013\u2014\u2015";
        String string2 = "\u2018\u2019\u201b\u2032\u2035";
        String string3 = "\u201c\u201d\u201f\u2033\u2036\u00ab\u00bb";
        this.toReplace = string + string2 + string3;
        String string4 = "";
        for (n = 0; n < string.length(); ++n) {
            string4 = string4 + '-';
        }
        for (n = 0; n < string2.length(); ++n) {
            string4 = string4 + '\'';
        }
        for (n = 0; n < string3.length(); ++n) {
            string4 = string4 + '\"';
        }
        this.replacements = string4;
    }

    public String cleanupText(String string) {
        StringBuilder stringBuilder = new StringBuilder(StringUtil.makePlainLinefeed(string));
        boolean bl = false;
        for (int i = 0; i < stringBuilder.length(); ++i) {
            int n;
            char c = stringBuilder.charAt(i);
            if (c == '\'') {
                boolean bl2 = bl = !bl;
            }
            if (bl || (n = this.toReplace.indexOf(c)) <= -1) continue;
            char c2 = this.replacements.charAt(n);
            stringBuilder.setCharAt(i, c2);
        }
        return stringBuilder.toString();
    }
}

