/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import workbench.gui.MainWindow;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.CheckBoxAction;
import workbench.gui.bookmarks.NamedScriptLocation;
import workbench.gui.components.ColumnWidthOptimizer;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.HistoryTextField;
import workbench.gui.components.SelectionHandler;
import workbench.gui.components.ValidatingDialog;
import workbench.gui.components.WbScrollPane;
import workbench.gui.components.WbTable;
import workbench.gui.components.WbTraversalPolicy;
import workbench.gui.editor.SearchAndReplace;
import workbench.gui.editor.SearchResult;
import workbench.gui.renderer.RendererSetup;
import workbench.gui.sql.SqlPanel;
import workbench.interfaces.MainPanel;
import workbench.interfaces.ValidatingComponent;
import workbench.resource.GuiSettings;
import workbench.resource.IconMgr;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.util.StringUtil;

public class GlobalSearch
extends JPanel
implements MouseListener,
ActionListener,
ValidatingComponent,
KeyListener,
ListSelectionListener {
    private final String settingsKey = "workbench.gui.global.search.";
    private final String caseProperty = "workbench.gui.global.search.ignoreCase";
    private final String wordProperty = "workbench.gui.global.search.wholeWord";
    private final String regexProperty = "workbench.gui.global.search.useRegEx";
    private final String contextLinesProperty = "workbench.gui.global.search.contextlines";
    private final String dialogProperty = "workbench.gui.global.search.dialog";
    private WbTable searchResult;
    private final MainWindow window;
    private ValidatingDialog dialog;
    private SearchResult selectedResult;
    private JButton startSearch;
    private JCheckBox ignoreCase;
    private JCheckBox wholeWord;
    private JCheckBox useRegEx;
    private JTextField contextLines;
    private HistoryTextField criteria;
    private SelectionHandler keyHandler;
    private CheckBoxAction rememberColumnWidths;

    public GlobalSearch(MainWindow mainWindow) {
        super(new GridBagLayout());
        this.window = mainWindow;
        this.rememberColumnWidths = new CheckBoxAction("MnuTxtBookmarksSaveWidths", "workbench.gui.global.search.save.colwidths");
        this.searchResult = new WbTable(false, false, false){

            @Override
            protected JPopupMenu getHeaderPopup() {
                JPopupMenu jPopupMenu = this.createLimitedHeaderPopup();
                jPopupMenu.addSeparator();
                jPopupMenu.add(GlobalSearch.this.rememberColumnWidths.getMenuItem());
                return jPopupMenu;
            }
        };
        this.searchResult.setAutoAdjustColumnWidths(false);
        this.searchResult.setSelectionMode(0);
        this.searchResult.setReadOnly(true);
        this.searchResult.setRendererSetup(new RendererSetup(false));
        this.searchResult.addMouseListener(this);
        this.searchResult.setColumnSelectionAllowed(false);
        this.searchResult.setAutoscrolls(false);
        this.searchResult.setRowSelectionAllowed(true);
        this.searchResult.setSortIgnoreCase(true);
        this.searchResult.setShowPopupMenu(false);
        this.searchResult.getSelectionModel().addListSelectionListener(this);
        this.keyHandler = new SelectionHandler(this.searchResult);
        this.startSearch = new JButton(ResourceMgr.getString("LblStartSearch"));
        this.startSearch.addActionListener(this);
        WbScrollPane wbScrollPane = new WbScrollPane(this.searchResult);
        JPanel jPanel = this.createSearchPanel();
        this.criteria.getEditor().getEditorComponent().addKeyListener(this);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)wbScrollPane, gridBagConstraints);
        WbTraversalPolicy wbTraversalPolicy = new WbTraversalPolicy();
        wbTraversalPolicy.addComponent(this.criteria);
        wbTraversalPolicy.addComponent(this.ignoreCase);
        wbTraversalPolicy.addComponent(this.wholeWord);
        wbTraversalPolicy.addComponent(this.useRegEx);
        wbTraversalPolicy.addComponent(this.startSearch);
        this.setFocusCycleRoot(true);
        this.searchResult.setFocusCycleRoot(false);
        this.setFocusTraversalPolicy(wbTraversalPolicy);
        this.restoreSettings();
    }

    private JPanel createSearchPanel() {
        this.ignoreCase = new JCheckBox(ResourceMgr.getString("LblSearchIgnoreCase"));
        this.ignoreCase.setToolTipText(ResourceMgr.getDescription("LblSearchIgnoreCase"));
        this.wholeWord = new JCheckBox(ResourceMgr.getString("LblSearchWordsOnly"));
        this.wholeWord.setToolTipText(ResourceMgr.getDescription("LblSearchWordsOnly"));
        this.useRegEx = new JCheckBox(ResourceMgr.getString("LblSearchRegEx"));
        this.useRegEx.setToolTipText(ResourceMgr.getDescription("LblSearchRegEx"));
        JLabel jLabel = new JLabel(ResourceMgr.getString("LblSearchCriteria"));
        this.criteria = new HistoryTextField(".search");
        int n = IconMgr.getInstance().getSizeForLabel() / 2;
        EmptyBorder emptyBorder = new EmptyBorder(0, 0, 0, n);
        JPanel jPanel = new JPanel(new BorderLayout());
        jLabel.setBorder(emptyBorder);
        jPanel.add((Component)jLabel, "Before");
        jPanel.add((Component)this.criteria, "Center");
        JPanel jPanel2 = new JPanel(new FlowLayout(3, 0, 0));
        jPanel2.add(this.ignoreCase);
        jPanel2.add(this.wholeWord);
        jPanel2.add(this.useRegEx);
        jPanel2.add(Box.createHorizontalStrut(n * 2));
        jPanel2.add(new JLabel("Context lines"));
        jPanel2.add(Box.createHorizontalStrut(n));
        this.contextLines = new JTextField(4);
        jPanel2.add(this.contextLines);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        jPanel3.add((Component)jPanel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(n, 0, 0, 0);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        jPanel3.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 22;
        jPanel3.add((Component)this.startSearch, gridBagConstraints);
        return jPanel3;
    }

    private SortedMap<String, SearchAndReplace> getSearcher() {
        int n = this.window.getTabCount();
        TreeMap<String, SearchAndReplace> treeMap = new TreeMap<String, SearchAndReplace>(StringUtil.NATURAL_COMPARATOR);
        for (int i = 0; i < n; ++i) {
            MainPanel mainPanel = this.window.getPanel(i).get();
            if (!(mainPanel instanceof SqlPanel)) continue;
            SearchAndReplace searchAndReplace = ((SqlPanel)mainPanel).getEditor().getReplacer();
            treeMap.put(mainPanel.getId(), searchAndReplace);
        }
        return treeMap;
    }

    private void setButtonsEnabled(boolean bl) {
        if (this.dialog == null) {
            return;
        }
        this.dialog.setButtonEnabled(0, bl);
        this.dialog.setButtonEnabled(1, bl);
    }

    private int[] getColumnWidths() {
        TableColumnModel tableColumnModel = this.searchResult.getColumnModel();
        if (tableColumnModel == null) {
            return null;
        }
        int n = tableColumnModel.getColumnCount();
        if (n == 0) {
            return null;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = tableColumnModel.getColumn(i).getWidth();
        }
        return nArray;
    }

    private void saveColumnWidths() {
        if (GuiSettings.getSaveSearchAllColWidths()) {
            int[] nArray = this.getColumnWidths();
            if (nArray == null) {
                return;
            }
            Settings.getInstance().setProperty("workbench.gui.global.search..search.colwidths", StringUtil.arrayToString(nArray));
        }
    }

    private int[] getSavedColumnWidths() {
        if (GuiSettings.getSaveSearchAllColWidths()) {
            String string = Settings.getInstance().getProperty("workbench.gui.global.search..search.colwidths", null);
            return StringUtil.stringToArray(string);
        }
        return null;
    }

    private int getContextLines() {
        return StringUtil.getIntValue(this.contextLines.getText(), 0);
    }

    private void doSearch() {
        Object object2;
        int[] nArray = this.getColumnWidths();
        if (nArray == null) {
            nArray = this.getSavedColumnWidths();
        }
        SortedMap<String, SearchAndReplace> sortedMap = this.getSearcher();
        ArrayList arrayList = new ArrayList();
        int n = this.getContextLines();
        String string = this.criteria.getText();
        boolean bl = this.ignoreCase.isSelected();
        boolean bl2 = this.wholeWord.isSelected();
        boolean bl3 = this.useRegEx.isSelected();
        for (Map.Entry<String, SearchAndReplace> object22 : sortedMap.entrySet()) {
            object2 = object22.getValue().findAll(string, bl, bl2, bl3, n);
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                SearchResult searchResult = (SearchResult)iterator.next();
                searchResult.setTabId(object22.getKey());
            }
            arrayList.addAll(object2);
        }
        DataStore dataStore = this.createDataStore();
        for (Object object2 : arrayList) {
            int n2 = dataStore.addRow();
            dataStore.setValue(n2, 0, (Object)this.window.getTabTitleById(((SearchResult)object2).getTabId()));
            dataStore.setValue(n2, 1, (Object)(((SearchResult)object2).getLineNumber() + 1));
            dataStore.setValue(n2, 2, (Object)((SearchResult)object2).getLineText());
            dataStore.getRow(n2).setUserObject(object2);
        }
        DataStoreTableModel dataStoreTableModel = new DataStoreTableModel(dataStore);
        dataStoreTableModel.setAllowEditing(false);
        this.searchResult.setModel(dataStoreTableModel, true);
        this.searchResult.setMultiLine(2);
        if (nArray == null) {
            object2 = new ColumnWidthOptimizer(this.searchResult);
            ((ColumnWidthOptimizer)object2).optimizeAllColWidth(true);
        } else {
            this.searchResult.applyColumnWidths(nArray);
        }
        this.searchResult.optimizeRowHeight();
        this.selectedResult = null;
        this.setButtonsEnabled(false);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.setButtonsEnabled(this.searchResult.getSelectedRowCount() == 1);
    }

    private DataStore createDataStore() {
        String[] stringArray = new String[]{ResourceMgr.getPlainString("LblGSTabName"), ResourceMgr.getPlainString("LblGSLineNr"), ResourceMgr.getPlainString("LblGSLineContent")};
        int[] nArray = new int[]{12, 4, 12};
        int[] nArray2 = new int[]{20, 5, 50};
        return new DataStore(stringArray, nArray, nArray2);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        this.keyHandler.handleKeyPressed(keyEvent);
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.criteria.getEditor().getEditorComponent() && keyEvent.getKeyChar() == '\n') {
            if ((this.searchResult.getRowCount() == 0 || this.searchResult.getSelectedRowCount() == 0) && StringUtil.isNonBlank(this.criteria.getText())) {
                this.doSearch();
            } else if (this.searchResult.getSelectedRowCount() == 1) {
                this.selectValueAndClose();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.startSearch) {
            this.doSearch();
        }
    }

    @Override
    public boolean validateInput() {
        if (this.dialog.getSelectedOption() == 2) {
            return true;
        }
        if (this.searchResult.getSelectedRowCount() == 1) {
            this.selectedResult = this.getSelectedSearchLocation();
            if (this.dialog.getSelectedOption() == 0) {
                this.jumpTo(this.selectedResult);
                return false;
            }
            if (this.dialog.getSelectedOption() == 1) {
                this.jumpTo(this.selectedResult);
                return true;
            }
        }
        return false;
    }

    @Override
    public void componentWillBeClosed() {
        this.saveSettings();
    }

    @Override
    public void componentDisplayed() {
        this.criteria.requestFocusInWindow();
        this.criteria.selectAll();
    }

    public SearchResult getSelectedSearchLocation() {
        int n = this.searchResult.getSelectedRow();
        if (n < 0) {
            return null;
        }
        return (SearchResult)this.searchResult.getDataStore().getRow(n).getUserObject();
    }

    public void selectValueAndClose() {
        this.selectedResult = this.getSelectedSearchLocation();
        this.jumpTo(this.selectedResult);
        this.dialog.approveAndClose();
    }

    public void restoreSettings() {
        this.criteria.restoreSettings(Settings.getInstance(), "workbench.gui.global.search..search");
        this.ignoreCase.setSelected(Settings.getInstance().getBoolProperty("workbench.gui.global.search.ignoreCase"));
        this.wholeWord.setSelected(Settings.getInstance().getBoolProperty("workbench.gui.global.search.wholeWord"));
        this.useRegEx.setSelected(Settings.getInstance().getBoolProperty("workbench.gui.global.search.useRegEx"));
        int n = Settings.getInstance().getIntProperty("workbench.gui.global.search.contextlines", 0);
        this.contextLines.setText(Integer.toString(n));
    }

    public void saveSettings() {
        this.saveColumnWidths();
        this.criteria.addToHistory(this.criteria.getText());
        this.criteria.saveSettings(Settings.getInstance(), "workbench.gui.global.search..search");
        Settings.getInstance().setProperty("workbench.gui.global.search.ignoreCase", this.ignoreCase.isSelected());
        Settings.getInstance().setProperty("workbench.gui.global.search.wholeWord", this.wholeWord.isSelected());
        Settings.getInstance().setProperty("workbench.gui.global.search.useRegEx", this.useRegEx.isSelected());
        Settings.getInstance().setProperty("workbench.gui.global.search.contextlines", this.getContextLines());
        Settings.getInstance().storeWindowSize(this.dialog, "workbench.gui.global.search.dialog");
        Settings.getInstance().storeWindowPosition(this.dialog, "workbench.gui.global.search.dialog");
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
            this.selectValueAndClose();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void jumpTo(SearchResult searchResult) {
        NamedScriptLocation namedScriptLocation = new NamedScriptLocation("", searchResult.getOffset(), searchResult.getTabId());
        EventQueue.invokeLater(() -> this.window.jumpToBookmark(namedScriptLocation));
    }

    public void displaySearchDialog() {
        String[] stringArray = new String[]{ResourceMgr.getString("LblGSShowLine"), ResourceMgr.getString("LblGSJump"), ResourceMgr.getString("LblClose")};
        this.dialog = new ValidatingDialog(this.window, ResourceMgr.getString("TxtWinGlobalSearch"), (JComponent)this, stringArray, false);
        this.setButtonsEnabled(false);
        ResourceMgr.setWindowIcons((Window)this.dialog, "find-all");
        if (!Settings.getInstance().restoreWindowSize(this.dialog, "workbench.gui.global.search.dialog")) {
            this.dialog.setSize(450, 350);
        }
        if (!Settings.getInstance().restoreWindowPosition(this.dialog, "workbench.gui.global.search.dialog")) {
            WbSwingUtilities.center(this.dialog, this.window);
        }
        this.dialog.setVisible(true);
    }
}

