/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor;

import workbench.gui.completion.InsertColumnMatcher;
import workbench.gui.completion.ParameterTipProvider;
import workbench.gui.sql.EditorPanel;
import workbench.gui.sql.SqlPanel;
import workbench.resource.ResourceMgr;
import workbench.sql.parser.ScriptParser;

public class InsertTipProvider
implements ParameterTipProvider {
    private SqlPanel sqlPanel;
    private int lastCommandStart = Integer.MAX_VALUE;
    private int lastCommandEnd = -1;
    private String lastCommand;
    private long lastParseTime = 0L;

    public InsertTipProvider(SqlPanel sqlPanel) {
        this.sqlPanel = sqlPanel;
    }

    @Override
    public String getCurrentTooltip() {
        EditorPanel editorPanel = this.sqlPanel.getEditor();
        int n = editorPanel.getCaretPosition();
        if (editorPanel.isModifiedAfter(this.lastParseTime) || n < this.lastCommandStart || n > this.lastCommandEnd) {
            this.lastParseTime = System.currentTimeMillis();
            ScriptParser scriptParser = ScriptParser.createScriptParser(this.sqlPanel.getConnection());
            scriptParser.setScript(editorPanel.getText());
            int n2 = scriptParser.getCommandIndexAtCursorPos(editorPanel.getCaretPosition());
            if (n2 < 0) {
                return null;
            }
            this.lastCommand = scriptParser.getCommand(n2);
            this.lastCommandStart = scriptParser.getStartPosForCommand(n2);
            this.lastCommandEnd = scriptParser.getEndPosForCommand(n2);
        }
        if (this.lastCommand == null) {
            this.lastParseTime = 0L;
            this.lastCommandStart = Integer.MAX_VALUE;
            this.lastCommandEnd = 0;
            return null;
        }
        int n3 = n - this.lastCommandStart;
        InsertColumnMatcher insertColumnMatcher = new InsertColumnMatcher(this.sqlPanel.getConnection(), this.lastCommand);
        String string = insertColumnMatcher.getTooltipForPosition(n3);
        if (string == null) {
            if (insertColumnMatcher.inColumnList(n3)) {
                string = ResourceMgr.getString("ErrNoInsertVal");
            }
            if (insertColumnMatcher.inValueList(n3)) {
                string = ResourceMgr.getString("ErrNoInsertCol");
            }
        }
        return string;
    }
}

