/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor;

import javax.swing.text.Segment;
import workbench.gui.editor.SyntaxUtilities;

public class KeywordMap {
    private final Keyword[] map;
    private boolean ignoreCase;
    private final int mapLength;

    public KeywordMap(boolean bl, int n) {
        this.mapLength = n;
        this.ignoreCase = bl;
        this.map = new Keyword[n];
    }

    public byte lookup(Segment segment, int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        int n3 = this.getSegmentMapKey(segment, n, n2);
        if (n3 < 0) {
            return 0;
        }
        Keyword keyword = this.map[n3];
        while (keyword != null) {
            if (n2 != keyword.keyword.length) {
                keyword = keyword.next;
                continue;
            }
            if (SyntaxUtilities.regionMatches(this.ignoreCase, segment, n, keyword.keyword)) {
                return keyword.id;
            }
            keyword = keyword.next;
        }
        return 0;
    }

    public boolean containsKey(String string) {
        if (string == null) {
            return false;
        }
        Segment segment = new Segment(string.toCharArray(), 0, string.length());
        return this.lookup(segment, 0, string.length()) != 0;
    }

    public void add(String string, byte by) {
        if (this.containsKey(string)) {
            return;
        }
        int n = this.getStringMapKey(string);
        this.map[n] = new Keyword(string.toCharArray(), by, this.map[n]);
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    protected int getStringMapKey(String string) {
        return (Character.toUpperCase(string.charAt(0)) + Character.toUpperCase(string.charAt(string.length() - 1))) % this.mapLength;
    }

    protected int getSegmentMapKey(Segment segment, int n, int n2) {
        if (n < 0) {
            return -1;
        }
        if (n + n2 - 1 > segment.getEndIndex()) {
            return -1;
        }
        if (n + n2 - 1 < 0) {
            return -1;
        }
        return (Character.toUpperCase(segment.array[n]) + Character.toUpperCase(segment.array[n + n2 - 1])) % this.mapLength;
    }

    static class Keyword {
        public final char[] keyword;
        public final byte id;
        public final Keyword next;

        Keyword(char[] cArray, byte by, Keyword keyword) {
            this.keyword = cArray;
            this.id = by;
            this.next = keyword;
        }
    }
}

