/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor;

public class Token {
    public static final byte NULL = 0;
    public static final byte COMMENT1 = 1;
    public static final byte COMMENT2 = 2;
    public static final byte LITERAL1 = 3;
    public static final byte LITERAL2 = 4;
    public static final byte DATATYPE = 5;
    public static final byte KEYWORD1 = 6;
    public static final byte KEYWORD2 = 7;
    public static final byte KEYWORD3 = 8;
    public static final byte OPERATOR = 9;
    public static final byte INVALID = 10;
    public static final byte ID_COUNT = 11;
    public static final byte INTERNAL_FIRST = 100;
    public static final byte INTERNAL_LAST = 126;
    private char pendingChar = '\u0000';
    public int length;
    public byte id;
    public Token next;

    public Token(int n, byte by) {
        this.length = n;
        this.id = by;
    }

    public boolean isLiteral() {
        return Token.isLiteral(this.id);
    }

    public boolean isMultiline() {
        return this.pendingChar != '\u0000';
    }

    public void setPendingLiteralChar(char c) {
        this.pendingChar = c;
    }

    public char getPendingLiteralChar() {
        return this.pendingChar;
    }

    public static boolean isLiteral(int n) {
        return n == 3 || n == 4;
    }

    public String typeString() {
        return Token.typeString(this.id);
    }

    public static String typeString(int n) {
        String string = "NULL";
        switch (n) {
            case 1: {
                string = "C1";
                break;
            }
            case 2: {
                string = "C2";
                break;
            }
            case 3: {
                string = "L1";
                break;
            }
            case 4: {
                string = "L2";
                break;
            }
            case 6: {
                string = "K1";
                break;
            }
            case 7: {
                string = "K2";
                break;
            }
            case 8: {
                string = "K3";
                break;
            }
            case 9: {
                string = "OP";
                break;
            }
            case 0: {
                string = "NL";
                break;
            }
            default: {
                string = "OT";
            }
        }
        return string;
    }

    public String toString() {
        return "[type=" + this.typeString() + ",length=" + this.length + "]";
    }
}

