/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor.actions;

import java.awt.event.ActionEvent;
import javax.swing.text.BadLocationException;
import workbench.gui.editor.JEditTextArea;
import workbench.gui.editor.actions.EditorAction;

public class DeleteChar
extends EditorAction {
    public DeleteChar() {
        super("TxtEdDelChar", 127, 0);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JEditTextArea jEditTextArea = this.getTextArea(actionEvent);
        if (!jEditTextArea.isEditable()) {
            jEditTextArea.getToolkit().beep();
            return;
        }
        if (jEditTextArea.getSelectionStart() != jEditTextArea.getSelectionEnd()) {
            if (jEditTextArea.isEmptyRectangleSelection()) {
                jEditTextArea.doRectangleDeleteChar();
            } else {
                jEditTextArea.setSelectedText("");
            }
        } else {
            int n = jEditTextArea.getCaretPosition();
            if (n == jEditTextArea.getDocumentLength()) {
                jEditTextArea.getToolkit().beep();
                return;
            }
            try {
                jEditTextArea.getDocument().remove(n, 1);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }
}

