/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.editor.actions;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import workbench.gui.editor.JEditTextArea;
import workbench.gui.editor.TextUtilities;
import workbench.gui.editor.actions.EditorAction;
import workbench.resource.PlatformShortcuts;

public class PrevWord
extends EditorAction {
    protected boolean select;

    public PrevWord() {
        super("TxtEdPrvWord", PlatformShortcuts.getDefaultPrevWord(false));
        this.select = false;
    }

    public PrevWord(String string, KeyStroke keyStroke) {
        super(string, keyStroke);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JEditTextArea jEditTextArea = this.getTextArea(actionEvent);
        int n = jEditTextArea.getCaretPosition();
        int n2 = jEditTextArea.getCaretLine();
        int n3 = jEditTextArea.getLineStartOffset(n2);
        String string = jEditTextArea.getLineText(jEditTextArea.getCaretLine());
        if ((n -= n3) == 0) {
            if (n3 == 0) {
                jEditTextArea.getToolkit().beep();
                return;
            }
            --n;
        } else {
            n = TextUtilities.findWordStart(string, n);
        }
        if (this.select) {
            jEditTextArea.select(jEditTextArea.getMarkPosition(), n3 + n);
        } else {
            jEditTextArea.setCaretPosition(n3 + n);
        }
    }
}

