/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import workbench.WbManager;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.DataStoreTableModel;
import workbench.gui.components.ValidatingDialog;
import workbench.gui.components.WbLabel;
import workbench.gui.components.WbScrollPane;
import workbench.gui.components.WbTable;
import workbench.gui.components.WbTraversalPolicy;
import workbench.gui.renderer.RendererSetup;
import workbench.interfaces.ValidatingComponent;
import workbench.interfaces.ValueProvider;
import workbench.resource.ResourceMgr;
import workbench.resource.Settings;
import workbench.storage.DataStore;
import workbench.storage.filter.ContainsComparator;
import workbench.storage.filter.DataRowExpression;

public class ListValuePicker
extends JPanel
implements KeyListener,
ValidatingComponent,
MouseListener,
ActionListener {
    private JTextField filterValue;
    private WbScrollPane scroll;
    private ValidatingDialog dialog;
    private WbTable lookupData;
    private Object currentValue;

    public ListValuePicker(Collection<String> collection, String string, Object object) {
        super(new GridBagLayout());
        this.currentValue = object;
        this.filterValue = new JTextField();
        this.filterValue.addKeyListener(this);
        this.filterValue.addActionListener(this);
        this.lookupData = new WbTable(false, false, false);
        this.lookupData.setSelectionMode(0);
        this.lookupData.setReadOnly(true);
        this.lookupData.setRendererSetup(new RendererSetup(false));
        this.lookupData.addMouseListener(this);
        this.lookupData.setColumnSelectionAllowed(false);
        this.lookupData.setRowSelectionAllowed(true);
        DataStore dataStore = new DataStore(new String[]{string}, new int[]{12});
        for (String object22 : collection) {
            int abstractAction = dataStore.addRow();
            dataStore.setValue(abstractAction, 0, (Object)object22);
        }
        DataStoreTableModel dataStoreTableModel = new DataStoreTableModel(dataStore);
        dataStoreTableModel.setAllowEditing(false);
        this.lookupData.setModel(dataStoreTableModel, true);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FocusTraversalPolicy focusTraversalPolicy = ListValuePicker.this.getFocusTraversalPolicy();
                Component component = focusTraversalPolicy.getComponentAfter(ListValuePicker.this, ListValuePicker.this.lookupData);
                component.requestFocusInWindow();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FocusTraversalPolicy focusTraversalPolicy = ListValuePicker.this.getFocusTraversalPolicy();
                Component component = focusTraversalPolicy.getComponentBefore(ListValuePicker.this, ListValuePicker.this.lookupData);
                component.requestFocusInWindow();
            }
        };
        InputMap inputMap = this.lookupData.getInputMap(0);
        inputMap.put(WbSwingUtilities.TAB, "picker-next-comp");
        inputMap.put(WbSwingUtilities.SHIFT_TAB, "picker-prev-comp");
        AbstractAction abstractAction3 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ListValuePicker.this.selectValue();
            }
        };
        this.lookupData.configureEnterKeyAction(abstractAction3);
        this.lookupData.getActionMap().put("picker-next-comp", abstractAction);
        this.lookupData.getActionMap().put("picker-prev-comp", abstractAction2);
        this.scroll = new WbScrollPane(this.lookupData);
        JPanel jPanel = new JPanel(new BorderLayout(0, 0));
        WbLabel wbLabel = new WbLabel();
        wbLabel.setTextByKey("LblFkFilterValue", false);
        wbLabel.setLabelFor(this.filterValue);
        wbLabel.setBorder(new EmptyBorder(0, 0, 0, 10));
        jPanel.add((Component)wbLabel, "West");
        jPanel.add((Component)this.filterValue, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)jPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(10, 0, 2, 0);
        this.add((Component)this.scroll, gridBagConstraints);
        WbTraversalPolicy wbTraversalPolicy = new WbTraversalPolicy();
        wbTraversalPolicy.addComponent(this.filterValue);
        wbTraversalPolicy.addComponent(this.lookupData);
        this.setFocusCycleRoot(true);
        this.lookupData.setFocusCycleRoot(false);
        this.setFocusTraversalPolicy(wbTraversalPolicy);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.filterValue) {
            this.applyFilter();
        }
    }

    private void findCurrentValue() {
        if (this.currentValue == null) {
            return;
        }
        boolean bl = false;
        int n = this.lookupData.getRowCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.lookupData.getValueAt(i, 0);
            if (!this.currentValue.equals(object)) continue;
            this.lookupData.getSelectionModel().setSelectionInterval(i, i);
            bl = true;
            break;
        }
        if (!bl) {
            this.lookupData.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    protected String getSelectedValue() {
        int n = this.lookupData.getSelectedRow();
        if (n < 0) {
            return null;
        }
        return this.lookupData.getValueAsString(n, 0);
    }

    protected void resetFilter() {
        this.lookupData.resetFilter();
    }

    protected void applyFilter() {
        ContainsComparator containsComparator = new ContainsComparator();
        DataRowExpression dataRowExpression = new DataRowExpression(containsComparator, this.filterValue.getText());
        dataRowExpression.setIgnoreCase(true);
        this.lookupData.applyFilter(dataRowExpression);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        EventQueue.invokeLater(() -> {
            if (keyEvent.getKeyChar() == '\u001b') {
                this.resetFilter();
            } else {
                this.applyFilter();
            }
        });
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public boolean validateInput() {
        return this.lookupData.getSelectedRowCount() == 1;
    }

    @Override
    public void componentDisplayed() {
        this.findCurrentValue();
        this.lookupData.requestFocus();
    }

    @Override
    public void componentWillBeClosed() {
    }

    public void selectValue() {
        this.dialog.approveAndClose();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.selectValue();
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String pickValue(JComponent jComponent, String string, ValueProvider valueProvider, String string2) {
        try {
            WbSwingUtilities.showWaitCursor(jComponent);
            Collection<String> collection = valueProvider.getColumnValues(string);
            ListValuePicker listValuePicker = new ListValuePicker(collection, string, string2);
            Window window = SwingUtilities.getWindowAncestor(jComponent);
            String string3 = ResourceMgr.getString("TxtSelectValue");
            String string4 = "workbench.gui.listvaluepicker";
            ValidatingDialog validatingDialog = null;
            if (window instanceof JDialog) {
                validatingDialog = new ValidatingDialog((Dialog)((JDialog)window), string3, (JComponent)listValuePicker);
            } else if (window instanceof JFrame) {
                validatingDialog = new ValidatingDialog((Frame)((JFrame)window), string3, (JComponent)listValuePicker);
            }
            listValuePicker.dialog = validatingDialog;
            if (!Settings.getInstance().restoreWindowSize(validatingDialog, string4)) {
                validatingDialog.setSize(250, 300);
            }
            WbSwingUtilities.center(validatingDialog, WbManager.getInstance().getCurrentWindow());
            validatingDialog.setVisible(true);
            Settings.getInstance().storeWindowSize(validatingDialog, string4);
            if (validatingDialog.isCancelled()) {
                String string5 = null;
                return string5;
            }
            String string6 = listValuePicker.getSelectedValue();
            return string6;
        }
        finally {
            WbSwingUtilities.showDefaultCursor(jComponent);
        }
    }
}

