/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.lnf;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import workbench.gui.lnf.LnFDefinition;
import workbench.resource.Settings;
import workbench.util.ClasspathUtil;

public class LnFLoader {
    private LnFDefinition lnfDef;

    public LnFLoader(LnFDefinition lnFDefinition) {
        this.lnfDef = lnFDefinition;
    }

    public boolean isAvailable() {
        if (this.lnfDef.isBuiltIn()) {
            return true;
        }
        if (this.lnfDef.isExt()) {
            return true;
        }
        try {
            ClassLoader classLoader = this.createLoader();
            String string = this.lnfDef.getClassName().replace('.', '/') + ".class";
            URL uRL = classLoader.getResource(string);
            return uRL != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private ClassLoader createLoader() throws MalformedURLException {
        List<String> list = this.lnfDef.getLibraries();
        if (list != null && !this.lnfDef.isExt()) {
            URL[] uRLArray = new URL[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                String string = Settings.getInstance().replaceLibDirKey(list.get(i));
                File file = new File(string);
                if (!file.isAbsolute()) {
                    ClasspathUtil classpathUtil = new ClasspathUtil();
                    file = new File(classpathUtil.getJarPath(), list.get(i));
                }
                uRLArray[i] = file.toURI().toURL();
            }
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray, this.getClass().getClassLoader());
            return uRLClassLoader;
        }
        return null;
    }

    public Class loadClass() throws ClassNotFoundException {
        return this.loadClass(this.lnfDef.getClassName());
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            ClassLoader classLoader = this.createLoader();
            if (classLoader != null) {
                UIManager.getDefaults().put("ClassLoader", classLoader);
                Thread.currentThread().setContextClassLoader(classLoader);
                clazz = classLoader.loadClass(string);
            } else {
                UIManager.getDefaults().put("ClassLoader", (Object)null);
                clazz = Class.forName(string);
            }
        }
        catch (Exception exception) {
            throw new ClassNotFoundException("Could not load class " + string, exception);
        }
        return clazz;
    }

    public LookAndFeel getLookAndFeel() throws ClassNotFoundException {
        try {
            Class clazz = this.loadClass();
            return (LookAndFeel)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new ClassNotFoundException("Could not load class " + this.lnfDef.getClassName(), exception);
        }
    }
}

