/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.macros;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import workbench.gui.WbSwingUtilities;
import workbench.interfaces.ValidatingComponent;
import workbench.resource.ResourceMgr;
import workbench.sql.macros.MacroGroup;
import workbench.sql.macros.MacroManager;
import workbench.util.StringUtil;

public class AddMacroPanel
extends JPanel
implements WindowListener,
ValidatingComponent {
    private int macroClientId;
    private JCheckBox cbExpand;
    private JComboBox groupDropDown;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField macroName;

    public AddMacroPanel(int n) {
        this.initComponents();
        this.macroClientId = n;
        List<MacroGroup> list = MacroManager.getInstance().getMacros(this.macroClientId).getGroups();
        DefaultComboBoxModel<MacroGroup> defaultComboBoxModel = new DefaultComboBoxModel<MacroGroup>();
        for (MacroGroup macroGroup : list) {
            defaultComboBoxModel.addElement(macroGroup);
        }
        this.groupDropDown.setModel(defaultComboBoxModel);
    }

    public MacroGroup getSelectedGroup() {
        return (MacroGroup)this.groupDropDown.getSelectedItem();
    }

    public String getMacroName() {
        return this.macroName.getText();
    }

    public boolean getExpandWhileTyping() {
        return this.cbExpand.isSelected();
    }

    @Override
    public boolean validateInput() {
        boolean bl;
        String string = this.macroName.getText();
        if (StringUtil.isBlank(string)) {
            WbSwingUtilities.showErrorMessageKey(this, "ErrMcrNameReq");
            return false;
        }
        if (this.getExpandWhileTyping() && !(bl = string.matches("\\w+"))) {
            WbSwingUtilities.showErrorMessageKey(this, "ErrMcrNmNoSpace");
            return false;
        }
        return true;
    }

    @Override
    public void componentDisplayed() {
    }

    @Override
    public void componentWillBeClosed() {
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.groupDropDown = new JComboBox();
        this.macroName = new JTextField();
        this.cbExpand = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText(ResourceMgr.getString("LblMacroGrpName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 5, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText(ResourceMgr.getString("LblMacroName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 5, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.groupDropDown.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 9, 0, 5);
        this.add((Component)this.groupDropDown, gridBagConstraints);
        this.macroName.setColumns(30);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(7, 9, 0, 5);
        this.add((Component)this.macroName, gridBagConstraints);
        this.cbExpand.setText(ResourceMgr.getString("LblExpandMacro"));
        this.cbExpand.setToolTipText(ResourceMgr.getString("d_LblExpandMacro"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 1, 0, 0);
        this.add((Component)this.cbExpand, gridBagConstraints);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        EventQueue.invokeLater(this.macroName::requestFocusInWindow);
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

