/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.macros;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import workbench.db.WbConnection;
import workbench.gui.WbSwingUtilities;
import workbench.gui.actions.AutoCompletionAction;
import workbench.gui.components.BooleanPropertyEditor;
import workbench.gui.components.StringPropertyEditor;
import workbench.gui.components.WbTraversalPolicy;
import workbench.gui.settings.KeyboardMapper;
import workbench.gui.sql.EditorPanel;
import workbench.interfaces.StatusBar;
import workbench.resource.ResourceMgr;
import workbench.resource.ShortcutManager;
import workbench.resource.StoreableKeyStroke;
import workbench.sql.macros.MacroDefinition;

public class MacroDefinitionPanel
extends JPanel
implements ActionListener {
    private EditorPanel macroEditor;
    private MacroDefinition currentMacro;
    private AutoCompletionAction completeAction;
    private JCheckBox appendResults;
    private JButton assignShortcutButton;
    private JButton clearShortcutButton;
    private JCheckBox doExpansion;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JPanel optionsPanel;
    private JLabel shortcutLabel;
    private JPanel shortcutPanel;
    private JTextField tfName;
    private JTextField tfTooltip;
    private JCheckBox visibleInMenu;
    private JCheckBox visibleInPopup;

    public MacroDefinitionPanel(PropertyChangeListener propertyChangeListener) {
        this.initComponents();
        this.macroEditor = EditorPanel.createSqlEditor();
        this.macroEditor.showFindOnPopupMenu();
        this.macroEditor.showFormatSql();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 2, 2, 5);
        this.add((Component)this.macroEditor, gridBagConstraints);
        WbSwingUtilities.setMinimumSize(this.macroEditor, 25, 70);
        WbTraversalPolicy wbTraversalPolicy = new WbTraversalPolicy();
        wbTraversalPolicy.addComponent(this.tfName);
        wbTraversalPolicy.addComponent(this.visibleInMenu);
        wbTraversalPolicy.addComponent(this.assignShortcutButton);
        wbTraversalPolicy.addComponent(this.clearShortcutButton);
        wbTraversalPolicy.addComponent(this.macroEditor);
        wbTraversalPolicy.setDefaultComponent(this.macroEditor);
        this.setFocusTraversalPolicy(wbTraversalPolicy);
        if (propertyChangeListener != null) {
            this.tfName.addPropertyChangeListener(propertyChangeListener);
        }
    }

    public void setMacro(MacroDefinition macroDefinition) {
        this.applyChanges();
        this.currentMacro = macroDefinition;
        this.assignShortcutButton.setEnabled(this.currentMacro != null);
        BooleanPropertyEditor booleanPropertyEditor = (BooleanPropertyEditor)this.visibleInMenu;
        booleanPropertyEditor.setSourceObject(macroDefinition, "visibleInMenu");
        booleanPropertyEditor.setImmediateUpdate(true);
        BooleanPropertyEditor booleanPropertyEditor2 = (BooleanPropertyEditor)this.visibleInPopup;
        booleanPropertyEditor2.setSourceObject(macroDefinition, "visibleInPopup");
        booleanPropertyEditor2.setImmediateUpdate(true);
        BooleanPropertyEditor booleanPropertyEditor3 = (BooleanPropertyEditor)this.doExpansion;
        booleanPropertyEditor3.setSourceObject(macroDefinition, "expandWhileTyping");
        booleanPropertyEditor3.setImmediateUpdate(true);
        BooleanPropertyEditor booleanPropertyEditor4 = (BooleanPropertyEditor)this.appendResults;
        booleanPropertyEditor4.setSourceObject(macroDefinition, "appendResult");
        booleanPropertyEditor4.setImmediateUpdate(true);
        StringPropertyEditor stringPropertyEditor = (StringPropertyEditor)this.tfName;
        stringPropertyEditor.setSourceObject(macroDefinition, "name");
        stringPropertyEditor.setImmediateUpdate(true);
        StringPropertyEditor stringPropertyEditor2 = (StringPropertyEditor)this.tfTooltip;
        stringPropertyEditor2.setSourceObject(macroDefinition, "tooltip");
        stringPropertyEditor2.setImmediateUpdate(true);
        this.updateShortcutDisplay();
        this.appendResults.setEnabled(!this.doExpansion.isSelected());
        EventQueue.invokeLater(() -> {
            if (this.currentMacro != null) {
                this.macroEditor.setText(this.currentMacro.getText());
                this.macroEditor.setCaretPosition(0);
            } else {
                this.macroEditor.setText("");
            }
        });
    }

    public void setCurrentConnection(WbConnection wbConnection) {
        this.macroEditor.setDatabaseConnection(wbConnection);
        if (wbConnection != null) {
            this.completeAction = new AutoCompletionAction(this.macroEditor, new StatusBar(){

                @Override
                public void setStatusMessage(String string, int n) {
                }

                @Override
                public void setStatusMessage(String string) {
                }

                @Override
                public void clearStatusMessage() {
                }

                @Override
                public void doRepaint() {
                }

                @Override
                public String getText() {
                    return "";
                }
            });
            this.completeAction.setConnection(wbConnection);
            this.completeAction.setEnabled(true);
        } else if (this.completeAction != null) {
            this.completeAction.setConnection(null);
            this.completeAction.setEnabled(false);
            this.macroEditor.removeKeyBinding(this.completeAction.getAccelerator());
        }
    }

    public void applyChanges() {
        if (this.currentMacro != null && this.macroEditor.isModified()) {
            this.currentMacro.setText(this.macroEditor.getText());
        }
    }

    private void updateShortcutDisplay() {
        StoreableKeyStroke storeableKeyStroke;
        StoreableKeyStroke storeableKeyStroke2 = storeableKeyStroke = this.currentMacro == null ? null : this.currentMacro.getShortcut();
        if (storeableKeyStroke != null) {
            this.shortcutLabel.setText("<html>" + ResourceMgr.getString("LblKeyDefKeyCol") + ": <span style=\"background-color:white;font-weight:bold\"><tt>&nbsp;" + storeableKeyStroke.toString() + "&nbsp;</tt></span></html>");
        } else {
            this.shortcutLabel.setText(ResourceMgr.getString("LblKeyDefKeyCol") + ": " + ResourceMgr.getString("LblNone"));
        }
    }

    public void selectMacroName() {
        EventQueue.invokeLater(this.tfName::requestFocusInWindow);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.tfName = new StringPropertyEditor();
        this.jLabel2 = new JLabel();
        this.tfTooltip = new StringPropertyEditor();
        this.optionsPanel = new JPanel();
        this.visibleInMenu = new BooleanPropertyEditor();
        this.jSeparator1 = new JSeparator();
        this.visibleInPopup = new BooleanPropertyEditor();
        this.jSeparator2 = new JSeparator();
        this.doExpansion = new BooleanPropertyEditor();
        this.jSeparator3 = new JSeparator();
        this.appendResults = new BooleanPropertyEditor();
        this.shortcutPanel = new JPanel();
        this.shortcutLabel = new JLabel();
        this.assignShortcutButton = new JButton();
        this.clearShortcutButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.jLabel1.setText(ResourceMgr.getString("LblMacroName"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 4, 0, 5);
        this.add((Component)this.tfName, gridBagConstraints);
        this.jLabel2.setText(ResourceMgr.getString("LblMacroToolTip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 4, 0, 5);
        this.add((Component)this.tfTooltip, gridBagConstraints);
        this.optionsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.optionsPanel.setLayout(new GridBagLayout());
        this.visibleInMenu.setText(ResourceMgr.getString("LblMacroGrpMenu"));
        this.visibleInMenu.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.optionsPanel.add((Component)this.visibleInMenu, gridBagConstraints);
        this.jSeparator1.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.optionsPanel.add((Component)this.jSeparator1, gridBagConstraints);
        this.visibleInPopup.setText(ResourceMgr.getString("LblMacroGrpPop"));
        this.visibleInPopup.setBorder(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.optionsPanel.add((Component)this.visibleInPopup, gridBagConstraints);
        this.jSeparator2.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.optionsPanel.add((Component)this.jSeparator2, gridBagConstraints);
        this.doExpansion.setText(ResourceMgr.getString("LblExpandMacro"));
        this.doExpansion.setToolTipText(ResourceMgr.getString("d_LblExpandMacro"));
        this.doExpansion.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.optionsPanel.add((Component)this.doExpansion, gridBagConstraints);
        this.jSeparator3.setOrientation(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        this.optionsPanel.add((Component)this.jSeparator3, gridBagConstraints);
        this.appendResults.setText(ResourceMgr.getString("LblAppendMacroData"));
        this.appendResults.setToolTipText(ResourceMgr.getString("d_LblAppendMacroData"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.optionsPanel.add((Component)this.appendResults, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 4, 0, 5);
        this.add((Component)this.optionsPanel, gridBagConstraints);
        this.shortcutPanel.setLayout(new GridBagLayout());
        this.shortcutLabel.setText(ResourceMgr.getString("LblKeyDefKeyCol"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        this.shortcutPanel.add((Component)this.shortcutLabel, gridBagConstraints);
        this.assignShortcutButton.setText(ResourceMgr.getString("LblAssignShortcut"));
        this.assignShortcutButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 7, 0, 0);
        this.shortcutPanel.add((Component)this.assignShortcutButton, gridBagConstraints);
        this.clearShortcutButton.setText(ResourceMgr.getString("LblClearShortcut"));
        this.clearShortcutButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.shortcutPanel.add((Component)this.clearShortcutButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(1, 4, 0, 5);
        this.add((Component)this.shortcutPanel, gridBagConstraints);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.doExpansion) {
            this.doExpansionActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.assignShortcutButton) {
            this.assignShortcutButtonActionPerformed(actionEvent);
        } else if (actionEvent.getSource() == this.clearShortcutButton) {
            this.clearShortcutButtonActionPerformed(actionEvent);
        }
    }

    private void assignShortcutButtonActionPerformed(ActionEvent actionEvent) {
        KeyStroke keyStroke;
        if (this.currentMacro != null && (keyStroke = KeyboardMapper.getKeyStroke(this)) != null) {
            Object object;
            String string = ShortcutManager.getInstance().getActionClassForKey(keyStroke);
            String string2 = ShortcutManager.getInstance().getActionNameForClass(string);
            if (string2 != null) {
                object = ResourceMgr.getFormattedString("MsgShortcutAlreadyAssigned", string2);
                boolean bl = WbSwingUtilities.getYesNo(this, (String)object);
                if (!bl) {
                    return;
                }
                ShortcutManager.getInstance().removeShortcut(string);
                ShortcutManager.getInstance().updateActions();
            }
            object = new StoreableKeyStroke(keyStroke);
            this.currentMacro.setShortcut((StoreableKeyStroke)object);
            this.updateShortcutDisplay();
        }
    }

    private void clearShortcutButtonActionPerformed(ActionEvent actionEvent) {
        if (this.currentMacro != null) {
            this.currentMacro.setShortcut(null);
            this.updateShortcutDisplay();
        }
    }

    private void doExpansionActionPerformed(ActionEvent actionEvent) {
        this.appendResults.setEnabled(!this.doExpansion.isSelected());
    }
}

