/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.macros;

import java.util.Map;
import workbench.db.exporter.TextRowDataConverter;
import workbench.gui.WbSwingUtilities;
import workbench.gui.macros.MacroClient;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.Settings;
import workbench.sql.VariablePool;
import workbench.sql.macros.MacroDefinition;
import workbench.storage.ResultInfo;
import workbench.storage.RowData;
import workbench.util.StringUtil;

public class MacroRunner {
    private String selectedTextKey = Settings.getInstance().getProperty("workbench.macro.key.selection", "${selection}$");
    private String selectedStatementKey = Settings.getInstance().getProperty("workbench.macro.key.selectedstmt", "${selected_statement}$");
    private String currentStatementKey = Settings.getInstance().getProperty("workbench.macro.key.currentstatement", "${current_statement}$");
    private String editorTextKey = Settings.getInstance().getProperty("workbench.macro.key.editortext", "${text}$");

    public void runMacro(MacroDefinition macroDefinition, MacroClient macroClient, boolean bl) {
        if (macroDefinition == null) {
            return;
        }
        String string = this.handleReplacement(macroDefinition.getText(), macroClient, true);
        if (string != null) {
            macroClient.executeMacroSql(string, bl, macroDefinition.isAppendResult());
        }
    }

    public String handleReplacement(String string, MacroClient macroClient, boolean bl) {
        String string2;
        if (macroClient == null || StringUtil.isBlank(string)) {
            return string;
        }
        if (this.hasSelectedKey(string)) {
            string2 = macroClient.getSelectedText();
            if (string2 == null && bl) {
                WbSwingUtilities.showErrorMessageKey(macroClient.getPanel(), "ErrNoSelection4Macro");
                return null;
            }
            string = this.replaceSelected(string, StringUtil.coalesce(string2, ""));
        }
        if (this.hasCurrentKey(string)) {
            string2 = macroClient.getStatementAtCursor();
            if (string2 == null && bl) {
                WbSwingUtilities.showErrorMessageKey(macroClient.getPanel(), "ErrNoCurrent4Macro");
                return null;
            }
            string = this.replaceCurrent(string, StringUtil.coalesce(string2, ""));
        }
        if (this.hasTextKey(string)) {
            string = this.replaceEditorText(string, macroClient.getText());
        }
        return string;
    }

    protected boolean hasTextKey(String string) {
        if (string == null) {
            return false;
        }
        return string.indexOf(this.editorTextKey) > -1;
    }

    protected boolean hasSelectedKey(String string) {
        if (string == null) {
            return false;
        }
        return string.indexOf(this.selectedTextKey) > -1 || string.indexOf(this.selectedStatementKey) > -1;
    }

    protected boolean hasCurrentKey(String string) {
        if (string == null) {
            return false;
        }
        return string.indexOf(this.currentStatementKey) > -1;
    }

    protected String replaceCurrent(String string, String string2) {
        if (string2 == null || string == null) {
            return string;
        }
        return StringUtil.replace(string, this.currentStatementKey, string2);
    }

    protected String replaceEditorText(String string, String string2) {
        if (string2 == null || string == null) {
            return string;
        }
        return StringUtil.replace(string, this.editorTextKey, string2);
    }

    protected String replaceSelected(String string, String string2) {
        if (string2 == null || string == null) {
            return string;
        }
        if (string.contains(this.selectedTextKey)) {
            return StringUtil.replace(string, this.selectedTextKey, string2);
        }
        if (string.contains(this.selectedStatementKey)) {
            String string3 = string2.trim();
            if (string3.endsWith(";")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            return StringUtil.replace(string, this.selectedStatementKey, string3);
        }
        return string;
    }

    public void runDataMacro(MacroDefinition macroDefinition, ResultInfo resultInfo, RowData rowData, MacroClient macroClient, Map<String, String> map) {
        if (macroDefinition == null) {
            return;
        }
        if (resultInfo == null) {
            return;
        }
        if (rowData == null) {
            return;
        }
        if (macroClient == null) {
            return;
        }
        TextRowDataConverter textRowDataConverter = new TextRowDataConverter();
        textRowDataConverter.setResultInfo(resultInfo);
        for (int i = 0; i < resultInfo.getColumnCount(); ++i) {
            String string = resultInfo.getColumnName(i);
            String string2 = map.get(string);
            if (string2 == null) {
                string2 = string;
            }
            if (VariablePool.getInstance().isValidVariableName(string2)) {
                String string3 = textRowDataConverter.getValueAsFormattedString(rowData, i);
                VariablePool.getInstance().setParameterValue(string2, string3);
                continue;
            }
            LogMgr.logWarning(new CallerInfo(){}, "Column name: " + string + " is not a valid SQL Workbench variable name. Column will be ignored.");
        }
        String string = macroDefinition.getText();
        macroClient.executeMacroSql(string, false, true);
    }
}

