/*
 * Decompiled with CFR 0.152.
 */
package workbench.gui.preparedstatement;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import workbench.WbManager;
import workbench.gui.WbSwingUtilities;
import workbench.gui.components.ValidatingDialog;
import workbench.gui.components.WbTable;
import workbench.gui.components.WbTextCellEditor;
import workbench.gui.preparedstatement.StatementParameterTableModel;
import workbench.gui.renderer.RendererSetup;
import workbench.interfaces.StatementParameterPrompter;
import workbench.interfaces.ValidatingComponent;
import workbench.log.CallerInfo;
import workbench.log.LogMgr;
import workbench.resource.ResourceMgr;
import workbench.sql.preparedstatement.StatementParameters;
import workbench.util.SqlUtil;

public class ParameterEditor
extends JPanel
implements ValidatingComponent {
    private WbTable parameterTable;
    private StatementParameters parameters;
    private StatementParameterTableModel model;
    private static boolean dialogResult = false;
    public static final StatementParameterPrompter GUI_PROMPTER = ParameterEditor::showParameterDialog;

    public ParameterEditor(StatementParameters statementParameters, boolean bl) {
        this.parameters = statementParameters;
        this.model = new StatementParameterTableModel(this.parameters, bl);
        this.parameterTable = new WbTable();
        this.parameterTable.setRowSelectionAllowed(false);
        this.parameterTable.setColumnSelectionAllowed(false);
        this.parameterTable.setModel(this.model);
        this.parameterTable.setAutoResizeMode(4);
        this.parameterTable.setRendererSetup(new RendererSetup(false));
        TableColumn tableColumn = this.parameterTable.getColumnModel().getColumn(2);
        tableColumn.setCellEditor(WbTextCellEditor.createInstance());
        JLabel jLabel = new JLabel(ResourceMgr.getString("TxtPSParameterInputText"));
        Border border = BorderFactory.createEmptyBorder(5, 2, 5, 2);
        jLabel.setBorder(border);
        jLabel.setBackground(Color.WHITE);
        jLabel.setOpaque(true);
        jLabel.setHorizontalAlignment(2);
        this.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.parameterTable);
        border = BorderFactory.createEmptyBorder(5, 0, 0, 0);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border, jScrollPane.getBorder());
        jScrollPane.setBorder(compoundBorder);
        this.add((Component)jLabel, "North");
        this.add((Component)jScrollPane, "Center");
    }

    public void applyValues() {
        this.parameterTable.stopEditing();
        int n = this.parameters.getParameterCount();
        for (int i = 0; i < n; ++i) {
            String string = this.model.getParameterValue(i);
            this.parameters.setParameterValue(i, string);
        }
    }

    @Override
    public void componentWillBeClosed() {
    }

    @Override
    public void componentDisplayed() {
        int n = this.parameterTable.getColumnCount();
        this.parameterTable.setColumnSelectionInterval(n - 1, n - 1);
        this.parameterTable.editCellAt(0, n - 1);
        TableCellEditor tableCellEditor = this.parameterTable.getCellEditor();
        if (tableCellEditor instanceof WbTextCellEditor) {
            WbTextCellEditor wbTextCellEditor = (WbTextCellEditor)tableCellEditor;
            wbTextCellEditor.selectAll();
            wbTextCellEditor.requestFocus();
        }
    }

    @Override
    public boolean validateInput() {
        this.parameterTable.stopEditing();
        int n = this.parameters.getParameterCount();
        for (int i = 0; i < n; ++i) {
            String string = this.model.getParameterValue(i);
            if (this.parameters.isValueValid(i, string)) continue;
            String string2 = ResourceMgr.getString("ErrInvalidPSParameterValue").replace("%value%", string);
            string2 = string2.replace("%type%", SqlUtil.getTypeName(this.parameters.getParameterType(i)));
            WbSwingUtilities.showErrorMessage(this, string2);
            return false;
        }
        return true;
    }

    public static synchronized boolean showParameterDialog(StatementParameters statementParameters, boolean bl) {
        WbSwingUtilities.invoke(() -> {
            ParameterEditor parameterEditor = new ParameterEditor(statementParameters, bl);
            Dimension dimension = new Dimension(300, 250);
            parameterEditor.setMinimumSize(dimension);
            parameterEditor.setPreferredSize(dimension);
            dialogResult = false;
            JFrame jFrame = WbManager.getInstance().getCurrentWindow();
            boolean bl2 = ValidatingDialog.showConfirmDialog(jFrame, parameterEditor, ResourceMgr.getString("TxtEditPSParameterWindowTitle"));
            if (bl2) {
                try {
                    parameterEditor.applyValues();
                    dialogResult = true;
                }
                catch (Exception exception) {
                    LogMgr.logError(new CallerInfo(){}, "Error when saving values", exception);
                    dialogResult = false;
                }
            }
        });
        return dialogResult;
    }
}

